<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for GetSimStatusDuringActivationErrorEnum EnumType
 * @subpackage Enumerations
 */
class GetSimStatusDuringActivationErrorEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'InvalidInput'
     * @return string 'InvalidInput'
     */
    const VALUE_INVALID_INPUT = 'InvalidInput';
    /**
     * Constant for value 'ModemVerificationFailure'
     * @return string 'ModemVerificationFailure'
     */
    const VALUE_MODEM_VERIFICATION_FAILURE = 'ModemVerificationFailure';
    /**
     * Constant for value 'ModemIsAlreadyActivated'
     * @return string 'ModemIsAlreadyActivated'
     */
    const VALUE_MODEM_IS_ALREADY_ACTIVATED = 'ModemIsAlreadyActivated';
    /**
     * Constant for value 'ModemIsNotAssociatedWithAUnitOrCustomer'
     * @return string 'ModemIsNotAssociatedWithAUnitOrCustomer'
     */
    const VALUE_MODEM_IS_NOT_ASSOCIATED_WITH_AUNIT_OR_CUSTOMER = 'ModemIsNotAssociatedWithAUnitOrCustomer';
    /**
     * Constant for value 'SimStatusUnavailableForNetwork'
     * @return string 'SimStatusUnavailableForNetwork'
     */
    const VALUE_SIM_STATUS_UNAVAILABLE_FOR_NETWORK = 'SimStatusUnavailableForNetwork';
    /**
     * Constant for value 'UnexpectedErrorWhenCheckingSimStatus'
     * @return string 'UnexpectedErrorWhenCheckingSimStatus'
     */
    const VALUE_UNEXPECTED_ERROR_WHEN_CHECKING_SIM_STATUS = 'UnexpectedErrorWhenCheckingSimStatus';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_INVALID_INPUT
     * @uses self::VALUE_MODEM_VERIFICATION_FAILURE
     * @uses self::VALUE_MODEM_IS_ALREADY_ACTIVATED
     * @uses self::VALUE_MODEM_IS_NOT_ASSOCIATED_WITH_AUNIT_OR_CUSTOMER
     * @uses self::VALUE_SIM_STATUS_UNAVAILABLE_FOR_NETWORK
     * @uses self::VALUE_UNEXPECTED_ERROR_WHEN_CHECKING_SIM_STATUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_INVALID_INPUT,
            self::VALUE_MODEM_VERIFICATION_FAILURE,
            self::VALUE_MODEM_IS_ALREADY_ACTIVATED,
            self::VALUE_MODEM_IS_NOT_ASSOCIATED_WITH_AUNIT_OR_CUSTOMER,
            self::VALUE_SIM_STATUS_UNAVAILABLE_FOR_NETWORK,
            self::VALUE_UNEXPECTED_ERROR_WHEN_CHECKING_SIM_STATUS,
        );
    }
}
