<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateLoginPasswordOutput StructType
 * @subpackage Structs
 */
class ValidateLoginPasswordOutput extends AbstractStructBase
{
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Result;
    /**
     * The MustChangePassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MustChangePassword;
    /**
     * The MustSignAgreements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MustSignAgreements;
    /**
     * The Customers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCustomerPermissions
     */
    public $Customers;
    /**
     * Constructor method for ValidateLoginPasswordOutput
     * @uses ValidateLoginPasswordOutput::setResult()
     * @uses ValidateLoginPasswordOutput::setMustChangePassword()
     * @uses ValidateLoginPasswordOutput::setMustSignAgreements()
     * @uses ValidateLoginPasswordOutput::setCustomers()
     * @param string $result
     * @param bool $mustChangePassword
     * @param bool $mustSignAgreements
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerPermissions $customers
     */
    public function __construct($result = null, $mustChangePassword = null, $mustSignAgreements = null, \CustomerManagement\ArrayType\ArrayOfCustomerPermissions $customers = null)
    {
        $this
            ->setResult($result)
            ->setMustChangePassword($mustChangePassword)
            ->setMustSignAgreements($mustSignAgreements)
            ->setCustomers($customers);
    }
    /**
     * Get Result value
     * @return string
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @uses \CustomerManagement\EnumType\LoginResult::valueIsValid()
     * @uses \CustomerManagement\EnumType\LoginResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $result
     * @return \CustomerManagement\StructType\ValidateLoginPasswordOutput
     */
    public function setResult($result = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\LoginResult::valueIsValid($result)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $result, implode(', ', \CustomerManagement\EnumType\LoginResult::getValidValues())), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get MustChangePassword value
     * @return bool
     */
    public function getMustChangePassword()
    {
        return $this->MustChangePassword;
    }
    /**
     * Set MustChangePassword value
     * @param bool $mustChangePassword
     * @return \CustomerManagement\StructType\ValidateLoginPasswordOutput
     */
    public function setMustChangePassword($mustChangePassword = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustChangePassword) && !is_bool($mustChangePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mustChangePassword)), __LINE__);
        }
        $this->MustChangePassword = $mustChangePassword;
        return $this;
    }
    /**
     * Get MustSignAgreements value
     * @return bool
     */
    public function getMustSignAgreements()
    {
        return $this->MustSignAgreements;
    }
    /**
     * Set MustSignAgreements value
     * @param bool $mustSignAgreements
     * @return \CustomerManagement\StructType\ValidateLoginPasswordOutput
     */
    public function setMustSignAgreements($mustSignAgreements = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustSignAgreements) && !is_bool($mustSignAgreements)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mustSignAgreements)), __LINE__);
        }
        $this->MustSignAgreements = $mustSignAgreements;
        return $this;
    }
    /**
     * Get Customers value
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerPermissions|null
     */
    public function getCustomers()
    {
        return $this->Customers;
    }
    /**
     * Set Customers value
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerPermissions $customers
     * @return \CustomerManagement\StructType\ValidateLoginPasswordOutput
     */
    public function setCustomers(\CustomerManagement\ArrayType\ArrayOfCustomerPermissions $customers = null)
    {
        $this->Customers = $customers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ValidateLoginPasswordOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
