<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNotificationSubscription ArrayType
 * @subpackage Arrays
 */
class ArrayOfNotificationSubscription extends AbstractStructArrayBase
{
    /**
     * The NotificationSubscription
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\NotificationSubscription[]
     */
    public $NotificationSubscription;
    /**
     * Constructor method for ArrayOfNotificationSubscription
     * @uses ArrayOfNotificationSubscription::setNotificationSubscription()
     * @param \CustomerManagement\StructType\NotificationSubscription[] $notificationSubscription
     */
    public function __construct(array $notificationSubscription = array())
    {
        $this
            ->setNotificationSubscription($notificationSubscription);
    }
    /**
     * Get NotificationSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\NotificationSubscription[]|null
     */
    public function getNotificationSubscription()
    {
        return isset($this->NotificationSubscription) ? $this->NotificationSubscription : null;
    }
    /**
     * Set NotificationSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\NotificationSubscription[] $notificationSubscription
     * @return \CustomerManagement\ArrayType\ArrayOfNotificationSubscription
     */
    public function setNotificationSubscription(array $notificationSubscription = array())
    {
        foreach ($notificationSubscription as $arrayOfNotificationSubscriptionNotificationSubscriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfNotificationSubscriptionNotificationSubscriptionItem instanceof \CustomerManagement\StructType\NotificationSubscription) {
                throw new \InvalidArgumentException(sprintf('The NotificationSubscription property can only contain items of \CustomerManagement\StructType\NotificationSubscription, "%s" given', is_object($arrayOfNotificationSubscriptionNotificationSubscriptionItem) ? get_class($arrayOfNotificationSubscriptionNotificationSubscriptionItem) : gettype($arrayOfNotificationSubscriptionNotificationSubscriptionItem)), __LINE__);
            }
        }
        if (is_null($notificationSubscription) || (is_array($notificationSubscription) && empty($notificationSubscription))) {
            unset($this->NotificationSubscription);
        } else {
            $this->NotificationSubscription = $notificationSubscription;
        }
        return $this;
    }
    /**
     * Add item to NotificationSubscription value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\NotificationSubscription $item
     * @return \CustomerManagement\ArrayType\ArrayOfNotificationSubscription
     */
    public function addToNotificationSubscription(\CustomerManagement\StructType\NotificationSubscription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\NotificationSubscription) {
            throw new \InvalidArgumentException(sprintf('The NotificationSubscription property can only contain items of \CustomerManagement\StructType\NotificationSubscription, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NotificationSubscription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\NotificationSubscription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\NotificationSubscription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\NotificationSubscription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\NotificationSubscription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\NotificationSubscription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NotificationSubscription
     */
    public function getAttributeName()
    {
        return 'NotificationSubscription';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfNotificationSubscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
