<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RiskScoreDetail StructType
 * @subpackage Structs
 */
class RiskScoreDetail extends AbstractStructBase
{
    /**
     * The MonthId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MonthId;
    /**
     * The RiskScore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RiskScore;
    /**
     * The RiskType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RiskType;
    /**
     * Constructor method for RiskScoreDetail
     * @uses RiskScoreDetail::setMonthId()
     * @uses RiskScoreDetail::setRiskScore()
     * @uses RiskScoreDetail::setRiskType()
     * @param int $monthId
     * @param float $riskScore
     * @param string $riskType
     */
    public function __construct($monthId = null, $riskScore = null, $riskType = null)
    {
        $this
            ->setMonthId($monthId)
            ->setRiskScore($riskScore)
            ->setRiskType($riskType);
    }
    /**
     * Get MonthId value
     * @return int
     */
    public function getMonthId()
    {
        return $this->MonthId;
    }
    /**
     * Set MonthId value
     * @param int $monthId
     * @return \CustomerManagement\StructType\RiskScoreDetail
     */
    public function setMonthId($monthId = null)
    {
        // validation for constraint: int
        if (!is_null($monthId) && !(is_int($monthId) || ctype_digit($monthId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthId, true), gettype($monthId)), __LINE__);
        }
        $this->MonthId = $monthId;
        return $this;
    }
    /**
     * Get RiskScore value
     * @return float
     */
    public function getRiskScore()
    {
        return $this->RiskScore;
    }
    /**
     * Set RiskScore value
     * @param float $riskScore
     * @return \CustomerManagement\StructType\RiskScoreDetail
     */
    public function setRiskScore($riskScore = null)
    {
        // validation for constraint: float
        if (!is_null($riskScore) && !(is_float($riskScore) || is_numeric($riskScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($riskScore, true), gettype($riskScore)), __LINE__);
        }
        $this->RiskScore = $riskScore;
        return $this;
    }
    /**
     * Get RiskType value
     * @return string|null
     */
    public function getRiskType()
    {
        return $this->RiskType;
    }
    /**
     * Set RiskType value
     * @param string $riskType
     * @return \CustomerManagement\StructType\RiskScoreDetail
     */
    public function setRiskType($riskType = null)
    {
        // validation for constraint: string
        if (!is_null($riskType) && !is_string($riskType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($riskType, true), gettype($riskType)), __LINE__);
        }
        $this->RiskType = $riskType;
        return $this;
    }
}
