<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerRiskScoreDwData StructType
 * @subpackage Structs
 */
class CustomerRiskScoreDwData extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The RiskScoreDetialsList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfRiskScoreDetail
     */
    public $RiskScoreDetialsList;
    /**
     * Constructor method for CustomerRiskScoreDwData
     * @uses CustomerRiskScoreDwData::setCustomerId()
     * @uses CustomerRiskScoreDwData::setRiskScoreDetialsList()
     * @param int $customerId
     * @param \CustomerManagement\ArrayType\ArrayOfRiskScoreDetail $riskScoreDetialsList
     */
    public function __construct($customerId = null, \CustomerManagement\ArrayType\ArrayOfRiskScoreDetail $riskScoreDetialsList = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setRiskScoreDetialsList($riskScoreDetialsList);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CustomerRiskScoreDwData
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get RiskScoreDetialsList value
     * @return \CustomerManagement\ArrayType\ArrayOfRiskScoreDetail|null
     */
    public function getRiskScoreDetialsList()
    {
        return $this->RiskScoreDetialsList;
    }
    /**
     * Set RiskScoreDetialsList value
     * @param \CustomerManagement\ArrayType\ArrayOfRiskScoreDetail $riskScoreDetialsList
     * @return \CustomerManagement\StructType\CustomerRiskScoreDwData
     */
    public function setRiskScoreDetialsList(\CustomerManagement\ArrayType\ArrayOfRiskScoreDetail $riskScoreDetialsList = null)
    {
        $this->RiskScoreDetialsList = $riskScoreDetialsList;
        return $this;
    }
}
