<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetVideoRecordingRuleExceptionStatusInput StructType
 * @subpackage Structs
 */
class SetVideoRecordingRuleExceptionStatusInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The RuleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RuleId;
    /**
     * The NewExceptionStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NewExceptionStatus;
    /**
     * Constructor method for SetVideoRecordingRuleExceptionStatusInput
     * @uses SetVideoRecordingRuleExceptionStatusInput::setCustomerId()
     * @uses SetVideoRecordingRuleExceptionStatusInput::setRuleId()
     * @uses SetVideoRecordingRuleExceptionStatusInput::setNewExceptionStatus()
     * @param int $customerId
     * @param int $ruleId
     * @param bool $newExceptionStatus
     */
    public function __construct($customerId = null, $ruleId = null, $newExceptionStatus = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setRuleId($ruleId)
            ->setNewExceptionStatus($newExceptionStatus);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SetVideoRecordingRuleExceptionStatusInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get RuleId value
     * @return int
     */
    public function getRuleId()
    {
        return $this->RuleId;
    }
    /**
     * Set RuleId value
     * @param int $ruleId
     * @return \CustomerManagement\StructType\SetVideoRecordingRuleExceptionStatusInput
     */
    public function setRuleId($ruleId = null)
    {
        // validation for constraint: int
        if (!is_null($ruleId) && !(is_int($ruleId) || ctype_digit($ruleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ruleId, true), gettype($ruleId)), __LINE__);
        }
        $this->RuleId = $ruleId;
        return $this;
    }
    /**
     * Get NewExceptionStatus value
     * @return bool
     */
    public function getNewExceptionStatus()
    {
        return $this->NewExceptionStatus;
    }
    /**
     * Set NewExceptionStatus value
     * @param bool $newExceptionStatus
     * @return \CustomerManagement\StructType\SetVideoRecordingRuleExceptionStatusInput
     */
    public function setNewExceptionStatus($newExceptionStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($newExceptionStatus) && !is_bool($newExceptionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newExceptionStatus, true), gettype($newExceptionStatus)), __LINE__);
        }
        $this->NewExceptionStatus = $newExceptionStatus;
        return $this;
    }
}
