<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRefreshTokenOutput StructType
 * @subpackage Structs
 */
class GetRefreshTokenOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The RefreshToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefreshToken;
    /**
     * Constructor method for GetRefreshTokenOutput
     * @uses GetRefreshTokenOutput::setSuccess()
     * @uses GetRefreshTokenOutput::setErrorMessage()
     * @uses GetRefreshTokenOutput::setRefreshToken()
     * @param bool $success
     * @param string $errorMessage
     * @param string $refreshToken
     */
    public function __construct($success = null, $errorMessage = null, $refreshToken = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setRefreshToken($refreshToken);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetRefreshTokenOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetRefreshTokenOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get RefreshToken value
     * @return string|null
     */
    public function getRefreshToken()
    {
        return $this->RefreshToken;
    }
    /**
     * Set RefreshToken value
     * @param string $refreshToken
     * @return \CustomerManagement\StructType\GetRefreshTokenOutput
     */
    public function setRefreshToken($refreshToken = null)
    {
        // validation for constraint: string
        if (!is_null($refreshToken) && !is_string($refreshToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refreshToken, true), gettype($refreshToken)), __LINE__);
        }
        $this->RefreshToken = $refreshToken;
        return $this;
    }
}
