<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HardResetModuleQolsysInput StructType
 * @subpackage Structs
 */
class HardResetModuleQolsysInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The PanelResetOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelResetOption;
    /**
     * Constructor method for HardResetModuleQolsysInput
     * @uses HardResetModuleQolsysInput::setCustomerId()
     * @uses HardResetModuleQolsysInput::setPanelResetOption()
     * @param int $customerId
     * @param string $panelResetOption
     */
    public function __construct($customerId = null, $panelResetOption = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setPanelResetOption($panelResetOption);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\HardResetModuleQolsysInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get PanelResetOption value
     * @return string
     */
    public function getPanelResetOption()
    {
        return $this->PanelResetOption;
    }
    /**
     * Set PanelResetOption value
     * @uses \CustomerManagement\EnumType\QolsysPanelResetOptionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\QolsysPanelResetOptionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelResetOption
     * @return \CustomerManagement\StructType\HardResetModuleQolsysInput
     */
    public function setPanelResetOption($panelResetOption = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\QolsysPanelResetOptionEnum::valueIsValid($panelResetOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\QolsysPanelResetOptionEnum', is_array($panelResetOption) ? implode(', ', $panelResetOption) : var_export($panelResetOption, true), implode(', ', \CustomerManagement\EnumType\QolsysPanelResetOptionEnum::getValidValues())), __LINE__);
        }
        $this->PanelResetOption = $panelResetOption;
        return $this;
    }
}
