<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReturnUrlInput StructType
 * @subpackage Structs
 */
class GetReturnUrlInput extends AbstractStructBase
{
    /**
     * The Page
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Page;
    /**
     * Constructor method for GetReturnUrlInput
     * @uses GetReturnUrlInput::setPage()
     * @param string $page
     */
    public function __construct($page = null)
    {
        $this
            ->setPage($page);
    }
    /**
     * Get Page value
     * @return string
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @uses \CustomerManagement\EnumType\ReturnUrlEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\ReturnUrlEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $page
     * @return \CustomerManagement\StructType\GetReturnUrlInput
     */
    public function setPage($page = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ReturnUrlEnum::valueIsValid($page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\ReturnUrlEnum', is_array($page) ? implode(', ', $page) : var_export($page, true), implode(', ', \CustomerManagement\EnumType\ReturnUrlEnum::getValidValues())), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
}
