<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for MessagePermissionEnum EnumType
 * @subpackage Enumerations
 */
class MessagePermissionEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'AlwaysReadWrite'
     * @return string 'AlwaysReadWrite'
     */
    const VALUE_ALWAYS_READ_WRITE = 'AlwaysReadWrite';
    /**
     * Constant for value 'AlwaysRead'
     * @return string 'AlwaysRead'
     */
    const VALUE_ALWAYS_READ = 'AlwaysRead';
    /**
     * Constant for value 'AlwaysNone'
     * @return string 'AlwaysNone'
     */
    const VALUE_ALWAYS_NONE = 'AlwaysNone';
    /**
     * Constant for value 'CompleteCustomerControl'
     * @return string 'CompleteCustomerControl'
     */
    const VALUE_COMPLETE_CUSTOMER_CONTROL = 'CompleteCustomerControl';
    /**
     * Return allowed values
     * @uses self::VALUE_ALWAYS_READ_WRITE
     * @uses self::VALUE_ALWAYS_READ
     * @uses self::VALUE_ALWAYS_NONE
     * @uses self::VALUE_COMPLETE_CUSTOMER_CONTROL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALWAYS_READ_WRITE,
            self::VALUE_ALWAYS_READ,
            self::VALUE_ALWAYS_NONE,
            self::VALUE_COMPLETE_CUSTOMER_CONTROL,
        );
    }
}
