<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPendingCommandInfoOutput StructType
 * @subpackage Structs
 */
class GetPendingCommandInfoOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The NumberOfCommandsReadyToSend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfCommandsReadyToSend;
    /**
     * The NumberOfCommandsNotYetReadyToSend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfCommandsNotYetReadyToSend;
    /**
     * The NextCommandToSendDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NextCommandToSendDate;
    /**
     * The LastCommandToSendDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastCommandToSendDate;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetPendingCommandInfoOutput
     * @uses GetPendingCommandInfoOutput::setSuccess()
     * @uses GetPendingCommandInfoOutput::setNumberOfCommandsReadyToSend()
     * @uses GetPendingCommandInfoOutput::setNumberOfCommandsNotYetReadyToSend()
     * @uses GetPendingCommandInfoOutput::setNextCommandToSendDate()
     * @uses GetPendingCommandInfoOutput::setLastCommandToSendDate()
     * @uses GetPendingCommandInfoOutput::setErrorMessage()
     * @param bool $success
     * @param int $numberOfCommandsReadyToSend
     * @param int $numberOfCommandsNotYetReadyToSend
     * @param string $nextCommandToSendDate
     * @param string $lastCommandToSendDate
     * @param string $errorMessage
     */
    public function __construct($success = null, $numberOfCommandsReadyToSend = null, $numberOfCommandsNotYetReadyToSend = null, $nextCommandToSendDate = null, $lastCommandToSendDate = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setNumberOfCommandsReadyToSend($numberOfCommandsReadyToSend)
            ->setNumberOfCommandsNotYetReadyToSend($numberOfCommandsNotYetReadyToSend)
            ->setNextCommandToSendDate($nextCommandToSendDate)
            ->setLastCommandToSendDate($lastCommandToSendDate)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetPendingCommandInfoOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get NumberOfCommandsReadyToSend value
     * @return int
     */
    public function getNumberOfCommandsReadyToSend()
    {
        return $this->NumberOfCommandsReadyToSend;
    }
    /**
     * Set NumberOfCommandsReadyToSend value
     * @param int $numberOfCommandsReadyToSend
     * @return \CustomerManagement\StructType\GetPendingCommandInfoOutput
     */
    public function setNumberOfCommandsReadyToSend($numberOfCommandsReadyToSend = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfCommandsReadyToSend) && !(is_int($numberOfCommandsReadyToSend) || ctype_digit($numberOfCommandsReadyToSend))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfCommandsReadyToSend, true), gettype($numberOfCommandsReadyToSend)), __LINE__);
        }
        $this->NumberOfCommandsReadyToSend = $numberOfCommandsReadyToSend;
        return $this;
    }
    /**
     * Get NumberOfCommandsNotYetReadyToSend value
     * @return int
     */
    public function getNumberOfCommandsNotYetReadyToSend()
    {
        return $this->NumberOfCommandsNotYetReadyToSend;
    }
    /**
     * Set NumberOfCommandsNotYetReadyToSend value
     * @param int $numberOfCommandsNotYetReadyToSend
     * @return \CustomerManagement\StructType\GetPendingCommandInfoOutput
     */
    public function setNumberOfCommandsNotYetReadyToSend($numberOfCommandsNotYetReadyToSend = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfCommandsNotYetReadyToSend) && !(is_int($numberOfCommandsNotYetReadyToSend) || ctype_digit($numberOfCommandsNotYetReadyToSend))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfCommandsNotYetReadyToSend, true), gettype($numberOfCommandsNotYetReadyToSend)), __LINE__);
        }
        $this->NumberOfCommandsNotYetReadyToSend = $numberOfCommandsNotYetReadyToSend;
        return $this;
    }
    /**
     * Get NextCommandToSendDate value
     * @return string
     */
    public function getNextCommandToSendDate()
    {
        return $this->NextCommandToSendDate;
    }
    /**
     * Set NextCommandToSendDate value
     * @param string $nextCommandToSendDate
     * @return \CustomerManagement\StructType\GetPendingCommandInfoOutput
     */
    public function setNextCommandToSendDate($nextCommandToSendDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextCommandToSendDate) && !is_string($nextCommandToSendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextCommandToSendDate, true), gettype($nextCommandToSendDate)), __LINE__);
        }
        $this->NextCommandToSendDate = $nextCommandToSendDate;
        return $this;
    }
    /**
     * Get LastCommandToSendDate value
     * @return string
     */
    public function getLastCommandToSendDate()
    {
        return $this->LastCommandToSendDate;
    }
    /**
     * Set LastCommandToSendDate value
     * @param string $lastCommandToSendDate
     * @return \CustomerManagement\StructType\GetPendingCommandInfoOutput
     */
    public function setLastCommandToSendDate($lastCommandToSendDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastCommandToSendDate) && !is_string($lastCommandToSendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastCommandToSendDate, true), gettype($lastCommandToSendDate)), __LINE__);
        }
        $this->LastCommandToSendDate = $lastCommandToSendDate;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetPendingCommandInfoOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
