<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeviceBatteryInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeviceBatteryInfo extends AbstractStructArrayBase
{
    /**
     * The DeviceBatteryInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\DeviceBatteryInfo[]
     */
    public $DeviceBatteryInfo;
    /**
     * Constructor method for ArrayOfDeviceBatteryInfo
     * @uses ArrayOfDeviceBatteryInfo::setDeviceBatteryInfo()
     * @param \CustomerManagement\StructType\DeviceBatteryInfo[] $deviceBatteryInfo
     */
    public function __construct(array $deviceBatteryInfo = array())
    {
        $this
            ->setDeviceBatteryInfo($deviceBatteryInfo);
    }
    /**
     * Get DeviceBatteryInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\DeviceBatteryInfo[]|null
     */
    public function getDeviceBatteryInfo()
    {
        return isset($this->DeviceBatteryInfo) ? $this->DeviceBatteryInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceBatteryInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceBatteryInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceBatteryInfoForArrayConstraintsFromSetDeviceBatteryInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDeviceBatteryInfoDeviceBatteryInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeviceBatteryInfoDeviceBatteryInfoItem instanceof \CustomerManagement\StructType\DeviceBatteryInfo) {
                $invalidValues[] = is_object($arrayOfDeviceBatteryInfoDeviceBatteryInfoItem) ? get_class($arrayOfDeviceBatteryInfoDeviceBatteryInfoItem) : sprintf('%s(%s)', gettype($arrayOfDeviceBatteryInfoDeviceBatteryInfoItem), var_export($arrayOfDeviceBatteryInfoDeviceBatteryInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeviceBatteryInfo property can only contain items of type \CustomerManagement\StructType\DeviceBatteryInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceBatteryInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\DeviceBatteryInfo[] $deviceBatteryInfo
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceBatteryInfo
     */
    public function setDeviceBatteryInfo(array $deviceBatteryInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($deviceBatteryInfoArrayErrorMessage = self::validateDeviceBatteryInfoForArrayConstraintsFromSetDeviceBatteryInfo($deviceBatteryInfo))) {
            throw new \InvalidArgumentException($deviceBatteryInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($deviceBatteryInfo) || (is_array($deviceBatteryInfo) && empty($deviceBatteryInfo))) {
            unset($this->DeviceBatteryInfo);
        } else {
            $this->DeviceBatteryInfo = $deviceBatteryInfo;
        }
        return $this;
    }
    /**
     * Add item to DeviceBatteryInfo value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\DeviceBatteryInfo $item
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceBatteryInfo
     */
    public function addToDeviceBatteryInfo(\CustomerManagement\StructType\DeviceBatteryInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\DeviceBatteryInfo) {
            throw new \InvalidArgumentException(sprintf('The DeviceBatteryInfo property can only contain items of type \CustomerManagement\StructType\DeviceBatteryInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeviceBatteryInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\DeviceBatteryInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\DeviceBatteryInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\DeviceBatteryInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\DeviceBatteryInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\DeviceBatteryInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeviceBatteryInfo
     */
    public function getAttributeName()
    {
        return 'DeviceBatteryInfo';
    }
}
