<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetImageSensorSettingsInput StructType
 * @subpackage Structs
 */
class SetImageSensorSettingsInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The Sensitivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Sensitivity;
    /**
     * The EnableAutoZoom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnableAutoZoom;
    /**
     * The EnableLEDMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnableLEDMode;
    /**
     * The EnableExtendedRangeOnDaughterboard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnableExtendedRangeOnDaughterboard;
    /**
     * Constructor method for SetImageSensorSettingsInput
     * @uses SetImageSensorSettingsInput::setCustomerId()
     * @uses SetImageSensorSettingsInput::setDeviceId()
     * @uses SetImageSensorSettingsInput::setSensitivity()
     * @uses SetImageSensorSettingsInput::setEnableAutoZoom()
     * @uses SetImageSensorSettingsInput::setEnableLEDMode()
     * @uses SetImageSensorSettingsInput::setEnableExtendedRangeOnDaughterboard()
     * @param int $customerId
     * @param int $deviceId
     * @param string $sensitivity
     * @param bool $enableAutoZoom
     * @param bool $enableLEDMode
     * @param bool $enableExtendedRangeOnDaughterboard
     */
    public function __construct($customerId = null, $deviceId = null, $sensitivity = null, $enableAutoZoom = null, $enableLEDMode = null, $enableExtendedRangeOnDaughterboard = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDeviceId($deviceId)
            ->setSensitivity($sensitivity)
            ->setEnableAutoZoom($enableAutoZoom)
            ->setEnableLEDMode($enableLEDMode)
            ->setEnableExtendedRangeOnDaughterboard($enableExtendedRangeOnDaughterboard);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get Sensitivity value
     * @return string
     */
    public function getSensitivity()
    {
        return $this->Sensitivity;
    }
    /**
     * Set Sensitivity value
     * @uses \CustomerManagement\EnumType\PirModeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PirModeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sensitivity
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setSensitivity($sensitivity = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PirModeEnum::valueIsValid($sensitivity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PirModeEnum', is_array($sensitivity) ? implode(', ', $sensitivity) : var_export($sensitivity, true), implode(', ', \CustomerManagement\EnumType\PirModeEnum::getValidValues())), __LINE__);
        }
        $this->Sensitivity = $sensitivity;
        return $this;
    }
    /**
     * Get EnableAutoZoom value
     * @return bool
     */
    public function getEnableAutoZoom()
    {
        return $this->EnableAutoZoom;
    }
    /**
     * Set EnableAutoZoom value
     * @param bool $enableAutoZoom
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setEnableAutoZoom($enableAutoZoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableAutoZoom) && !is_bool($enableAutoZoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableAutoZoom, true), gettype($enableAutoZoom)), __LINE__);
        }
        $this->EnableAutoZoom = $enableAutoZoom;
        return $this;
    }
    /**
     * Get EnableLEDMode value
     * @return bool
     */
    public function getEnableLEDMode()
    {
        return $this->EnableLEDMode;
    }
    /**
     * Set EnableLEDMode value
     * @param bool $enableLEDMode
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setEnableLEDMode($enableLEDMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableLEDMode) && !is_bool($enableLEDMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableLEDMode, true), gettype($enableLEDMode)), __LINE__);
        }
        $this->EnableLEDMode = $enableLEDMode;
        return $this;
    }
    /**
     * Get EnableExtendedRangeOnDaughterboard value
     * @return bool
     */
    public function getEnableExtendedRangeOnDaughterboard()
    {
        return $this->EnableExtendedRangeOnDaughterboard;
    }
    /**
     * Set EnableExtendedRangeOnDaughterboard value
     * @param bool $enableExtendedRangeOnDaughterboard
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setEnableExtendedRangeOnDaughterboard($enableExtendedRangeOnDaughterboard = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableExtendedRangeOnDaughterboard) && !is_bool($enableExtendedRangeOnDaughterboard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableExtendedRangeOnDaughterboard, true), gettype($enableExtendedRangeOnDaughterboard)), __LINE__);
        }
        $this->EnableExtendedRangeOnDaughterboard = $enableExtendedRangeOnDaughterboard;
        return $this;
    }
}
