<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DowngradeSecurityToSAVAccountInput StructType
 * @subpackage Structs
 */
class DowngradeSecurityToSAVAccountInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The NewPackageId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NewPackageId;
    /**
     * The NewPackageTemplateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NewPackageTemplateId;
    /**
     * The AddOnFeatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public $AddOnFeatures;
    /**
     * Constructor method for DowngradeSecurityToSAVAccountInput
     * @uses DowngradeSecurityToSAVAccountInput::setCustomerId()
     * @uses DowngradeSecurityToSAVAccountInput::setNewPackageId()
     * @uses DowngradeSecurityToSAVAccountInput::setNewPackageTemplateId()
     * @uses DowngradeSecurityToSAVAccountInput::setAddOnFeatures()
     * @param int $customerId
     * @param int $newPackageId
     * @param int $newPackageTemplateId
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     */
    public function __construct($customerId = null, $newPackageId = null, $newPackageTemplateId = null, \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewPackageId($newPackageId)
            ->setNewPackageTemplateId($newPackageTemplateId)
            ->setAddOnFeatures($addOnFeatures);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\DowngradeSecurityToSAVAccountInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get NewPackageId value
     * @return int
     */
    public function getNewPackageId()
    {
        return $this->NewPackageId;
    }
    /**
     * Set NewPackageId value
     * @param int $newPackageId
     * @return \CustomerManagement\StructType\DowngradeSecurityToSAVAccountInput
     */
    public function setNewPackageId($newPackageId = null)
    {
        // validation for constraint: int
        if (!is_null($newPackageId) && !(is_int($newPackageId) || ctype_digit($newPackageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newPackageId, true), gettype($newPackageId)), __LINE__);
        }
        $this->NewPackageId = $newPackageId;
        return $this;
    }
    /**
     * Get NewPackageTemplateId value
     * @return int
     */
    public function getNewPackageTemplateId()
    {
        return $this->NewPackageTemplateId;
    }
    /**
     * Set NewPackageTemplateId value
     * @param int $newPackageTemplateId
     * @return \CustomerManagement\StructType\DowngradeSecurityToSAVAccountInput
     */
    public function setNewPackageTemplateId($newPackageTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($newPackageTemplateId) && !(is_int($newPackageTemplateId) || ctype_digit($newPackageTemplateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newPackageTemplateId, true), gettype($newPackageTemplateId)), __LINE__);
        }
        $this->NewPackageTemplateId = $newPackageTemplateId;
        return $this;
    }
    /**
     * Get AddOnFeatures value
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum|null
     */
    public function getAddOnFeatures()
    {
        return $this->AddOnFeatures;
    }
    /**
     * Set AddOnFeatures value
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     * @return \CustomerManagement\StructType\DowngradeSecurityToSAVAccountInput
     */
    public function setAddOnFeatures(\CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this->AddOnFeatures = $addOnFeatures;
        return $this;
    }
}
