<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteEnterpriseGroupInput StructType
 * @subpackage Structs
 */
class DeleteEnterpriseGroupInput extends AbstractStructBase
{
    /**
     * The SystemGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemGroupId;
    /**
     * Constructor method for DeleteEnterpriseGroupInput
     * @uses DeleteEnterpriseGroupInput::setSystemGroupId()
     * @param int $systemGroupId
     */
    public function __construct($systemGroupId = null)
    {
        $this
            ->setSystemGroupId($systemGroupId);
    }
    /**
     * Get SystemGroupId value
     * @return int
     */
    public function getSystemGroupId()
    {
        return $this->SystemGroupId;
    }
    /**
     * Set SystemGroupId value
     * @param int $systemGroupId
     * @return \CustomerManagement\StructType\DeleteEnterpriseGroupInput
     */
    public function setSystemGroupId($systemGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($systemGroupId) && !(is_int($systemGroupId) || ctype_digit($systemGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemGroupId, true), gettype($systemGroupId)), __LINE__);
        }
        $this->SystemGroupId = $systemGroupId;
        return $this;
    }
}
