<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for RRIReportStatusEnum EnumType
 * @subpackage Enumerations
 */
class RRIReportStatusEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotFound'
     * @return string 'NotFound'
     */
    const VALUE_NOT_FOUND = 'NotFound';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Fault'
     * @return string 'Fault'
     */
    const VALUE_FAULT = 'Fault';
    /**
     * Constant for value 'SystemIsBusy'
     * @return string 'SystemIsBusy'
     */
    const VALUE_SYSTEM_IS_BUSY = 'SystemIsBusy';
    /**
     * Constant for value 'BadInputValue'
     * @return string 'BadInputValue'
     */
    const VALUE_BAD_INPUT_VALUE = 'BadInputValue';
    /**
     * Constant for value 'CompleteAndFailed'
     * @return string 'CompleteAndFailed'
     */
    const VALUE_COMPLETE_AND_FAILED = 'CompleteAndFailed';
    /**
     * Constant for value 'BadRepLoginCredentials'
     * @return string 'BadRepLoginCredentials'
     */
    const VALUE_BAD_REP_LOGIN_CREDENTIALS = 'BadRepLoginCredentials';
    /**
     * Constant for value 'FaultAndRetry'
     * @return string 'FaultAndRetry'
     */
    const VALUE_FAULT_AND_RETRY = 'FaultAndRetry';
    /**
     * Constant for value 'CompleteAndPassed'
     * @return string 'CompleteAndPassed'
     */
    const VALUE_COMPLETE_AND_PASSED = 'CompleteAndPassed';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_FOUND
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_FAULT
     * @uses self::VALUE_SYSTEM_IS_BUSY
     * @uses self::VALUE_BAD_INPUT_VALUE
     * @uses self::VALUE_COMPLETE_AND_FAILED
     * @uses self::VALUE_BAD_REP_LOGIN_CREDENTIALS
     * @uses self::VALUE_FAULT_AND_RETRY
     * @uses self::VALUE_COMPLETE_AND_PASSED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_FOUND,
            self::VALUE_PENDING,
            self::VALUE_FAULT,
            self::VALUE_SYSTEM_IS_BUSY,
            self::VALUE_BAD_INPUT_VALUE,
            self::VALUE_COMPLETE_AND_FAILED,
            self::VALUE_BAD_REP_LOGIN_CREDENTIALS,
            self::VALUE_FAULT_AND_RETRY,
            self::VALUE_COMPLETE_AND_PASSED,
        );
    }
}
