<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountRecycleInfoInput StructType
 * @subpackage Structs
 */
class GetAccountRecycleInfoInput extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The FailureReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FailureReason;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The OldCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OldCustomerId;
    /**
     * The NewCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NewCustomerId;
    /**
     * Constructor method for GetAccountRecycleInfoInput
     * @uses GetAccountRecycleInfoInput::setStatus()
     * @uses GetAccountRecycleInfoInput::setFailureReason()
     * @uses GetAccountRecycleInfoInput::setFromDate()
     * @uses GetAccountRecycleInfoInput::setToDate()
     * @uses GetAccountRecycleInfoInput::setOldCustomerId()
     * @uses GetAccountRecycleInfoInput::setNewCustomerId()
     * @param string $status
     * @param string $failureReason
     * @param string $fromDate
     * @param string $toDate
     * @param int $oldCustomerId
     * @param int $newCustomerId
     */
    public function __construct($status = null, $failureReason = null, $fromDate = null, $toDate = null, $oldCustomerId = null, $newCustomerId = null)
    {
        $this
            ->setStatus($status)
            ->setFailureReason($failureReason)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setOldCustomerId($oldCustomerId)
            ->setNewCustomerId($newCustomerId);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \CustomerManagement\EnumType\AccountRecycleStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\AccountRecycleStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CustomerManagement\StructType\GetAccountRecycleInfoInput
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\AccountRecycleStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\AccountRecycleStatusEnum', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \CustomerManagement\EnumType\AccountRecycleStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get FailureReason value
     * @return string
     */
    public function getFailureReason()
    {
        return $this->FailureReason;
    }
    /**
     * Set FailureReason value
     * @uses \CustomerManagement\EnumType\RecycleFailureReasonEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\RecycleFailureReasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failureReason
     * @return \CustomerManagement\StructType\GetAccountRecycleInfoInput
     */
    public function setFailureReason($failureReason = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\RecycleFailureReasonEnum::valueIsValid($failureReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\RecycleFailureReasonEnum', is_array($failureReason) ? implode(', ', $failureReason) : var_export($failureReason, true), implode(', ', \CustomerManagement\EnumType\RecycleFailureReasonEnum::getValidValues())), __LINE__);
        }
        $this->FailureReason = $failureReason;
        return $this;
    }
    /**
     * Get FromDate value
     * @return string
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \CustomerManagement\StructType\GetAccountRecycleInfoInput
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \CustomerManagement\StructType\GetAccountRecycleInfoInput
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get OldCustomerId value
     * @return int
     */
    public function getOldCustomerId()
    {
        return $this->OldCustomerId;
    }
    /**
     * Set OldCustomerId value
     * @param int $oldCustomerId
     * @return \CustomerManagement\StructType\GetAccountRecycleInfoInput
     */
    public function setOldCustomerId($oldCustomerId = null)
    {
        // validation for constraint: int
        if (!is_null($oldCustomerId) && !(is_int($oldCustomerId) || ctype_digit($oldCustomerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oldCustomerId, true), gettype($oldCustomerId)), __LINE__);
        }
        $this->OldCustomerId = $oldCustomerId;
        return $this;
    }
    /**
     * Get NewCustomerId value
     * @return int
     */
    public function getNewCustomerId()
    {
        return $this->NewCustomerId;
    }
    /**
     * Set NewCustomerId value
     * @param int $newCustomerId
     * @return \CustomerManagement\StructType\GetAccountRecycleInfoInput
     */
    public function setNewCustomerId($newCustomerId = null)
    {
        // validation for constraint: int
        if (!is_null($newCustomerId) && !(is_int($newCustomerId) || ctype_digit($newCustomerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newCustomerId, true), gettype($newCustomerId)), __LINE__);
        }
        $this->NewCustomerId = $newCustomerId;
        return $this;
    }
}
