<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddOnHistoryItem StructType
 * @subpackage Structs
 */
class AddOnHistoryItem extends AbstractStructBase
{
    /**
     * The ServicePlanFeatureId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePlanFeatureId;
    /**
     * The ChangeDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangeDateUtc;
    /**
     * The ChangeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChangeType;
    /**
     * The ServicePlanFeatureDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServicePlanFeatureDescription;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Quantity;
    /**
     * Constructor method for AddOnHistoryItem
     * @uses AddOnHistoryItem::setServicePlanFeatureId()
     * @uses AddOnHistoryItem::setChangeDateUtc()
     * @uses AddOnHistoryItem::setChangeType()
     * @uses AddOnHistoryItem::setServicePlanFeatureDescription()
     * @uses AddOnHistoryItem::setQuantity()
     * @param int $servicePlanFeatureId
     * @param string $changeDateUtc
     * @param string $changeType
     * @param string $servicePlanFeatureDescription
     * @param string $quantity
     */
    public function __construct($servicePlanFeatureId = null, $changeDateUtc = null, $changeType = null, $servicePlanFeatureDescription = null, $quantity = null)
    {
        $this
            ->setServicePlanFeatureId($servicePlanFeatureId)
            ->setChangeDateUtc($changeDateUtc)
            ->setChangeType($changeType)
            ->setServicePlanFeatureDescription($servicePlanFeatureDescription)
            ->setQuantity($quantity);
    }
    /**
     * Get ServicePlanFeatureId value
     * @return int
     */
    public function getServicePlanFeatureId()
    {
        return $this->ServicePlanFeatureId;
    }
    /**
     * Set ServicePlanFeatureId value
     * @param int $servicePlanFeatureId
     * @return \CustomerManagement\StructType\AddOnHistoryItem
     */
    public function setServicePlanFeatureId($servicePlanFeatureId = null)
    {
        // validation for constraint: int
        if (!is_null($servicePlanFeatureId) && !(is_int($servicePlanFeatureId) || ctype_digit($servicePlanFeatureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($servicePlanFeatureId, true), gettype($servicePlanFeatureId)), __LINE__);
        }
        $this->ServicePlanFeatureId = $servicePlanFeatureId;
        return $this;
    }
    /**
     * Get ChangeDateUtc value
     * @return string
     */
    public function getChangeDateUtc()
    {
        return $this->ChangeDateUtc;
    }
    /**
     * Set ChangeDateUtc value
     * @param string $changeDateUtc
     * @return \CustomerManagement\StructType\AddOnHistoryItem
     */
    public function setChangeDateUtc($changeDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($changeDateUtc) && !is_string($changeDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeDateUtc, true), gettype($changeDateUtc)), __LINE__);
        }
        $this->ChangeDateUtc = $changeDateUtc;
        return $this;
    }
    /**
     * Get ChangeType value
     * @return string|null
     */
    public function getChangeType()
    {
        return $this->ChangeType;
    }
    /**
     * Set ChangeType value
     * @param string $changeType
     * @return \CustomerManagement\StructType\AddOnHistoryItem
     */
    public function setChangeType($changeType = null)
    {
        // validation for constraint: string
        if (!is_null($changeType) && !is_string($changeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeType, true), gettype($changeType)), __LINE__);
        }
        $this->ChangeType = $changeType;
        return $this;
    }
    /**
     * Get ServicePlanFeatureDescription value
     * @return string|null
     */
    public function getServicePlanFeatureDescription()
    {
        return $this->ServicePlanFeatureDescription;
    }
    /**
     * Set ServicePlanFeatureDescription value
     * @param string $servicePlanFeatureDescription
     * @return \CustomerManagement\StructType\AddOnHistoryItem
     */
    public function setServicePlanFeatureDescription($servicePlanFeatureDescription = null)
    {
        // validation for constraint: string
        if (!is_null($servicePlanFeatureDescription) && !is_string($servicePlanFeatureDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicePlanFeatureDescription, true), gettype($servicePlanFeatureDescription)), __LINE__);
        }
        $this->ServicePlanFeatureDescription = $servicePlanFeatureDescription;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \CustomerManagement\StructType\AddOnHistoryItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
}
