<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for DualPathModeEnum EnumType
 * @subpackage Enumerations
 */
class DualPathModeEnum
{
    /**
     * Constant for value 'NonDualpathPanel'
     * @return string 'NonDualpathPanel'
     */
    const VALUE_NON_DUALPATH_PANEL = 'NonDualpathPanel';
    /**
     * Constant for value 'CellOnly'
     * @return string 'CellOnly'
     */
    const VALUE_CELL_ONLY = 'CellOnly';
    /**
     * Constant for value 'BroadbandOnly'
     * @return string 'BroadbandOnly'
     */
    const VALUE_BROADBAND_ONLY = 'BroadbandOnly';
    /**
     * Constant for value 'CellAndBroadband'
     * @return string 'CellAndBroadband'
     */
    const VALUE_CELL_AND_BROADBAND = 'CellAndBroadband';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NON_DUALPATH_PANEL
     * @uses self::VALUE_CELL_ONLY
     * @uses self::VALUE_BROADBAND_ONLY
     * @uses self::VALUE_CELL_AND_BROADBAND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NON_DUALPATH_PANEL,
            self::VALUE_CELL_ONLY,
            self::VALUE_BROADBAND_ONLY,
            self::VALUE_CELL_AND_BROADBAND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
