<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerInstallTypeInput StructType
 * @subpackage Structs
 */
class UpdateCustomerInstallTypeInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The InstallType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InstallType;
    /**
     * Constructor method for UpdateCustomerInstallTypeInput
     * @uses UpdateCustomerInstallTypeInput::setCustomerId()
     * @uses UpdateCustomerInstallTypeInput::setInstallType()
     * @param int $customerId
     * @param string $installType
     */
    public function __construct($customerId = null, $installType = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setInstallType($installType);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomerInstallTypeInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get InstallType value
     * @return string
     */
    public function getInstallType()
    {
        return $this->InstallType;
    }
    /**
     * Set InstallType value
     * @uses \CustomerManagement\EnumType\CustomerInstallTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerInstallTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installType
     * @return \CustomerManagement\StructType\UpdateCustomerInstallTypeInput
     */
    public function setInstallType($installType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerInstallTypeEnum::valueIsValid($installType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CustomerInstallTypeEnum', is_array($installType) ? implode(', ', $installType) : var_export($installType, true), implode(', ', \CustomerManagement\EnumType\CustomerInstallTypeEnum::getValidValues())), __LINE__);
        }
        $this->InstallType = $installType;
        return $this;
    }
}
