<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestUpdatedEquipmentList StructType
 * @subpackage Structs
 */
class RequestUpdatedEquipmentList extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The maxZones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $maxZones;
    /**
     * Constructor method for RequestUpdatedEquipmentList
     * @uses RequestUpdatedEquipmentList::setCustomerId()
     * @uses RequestUpdatedEquipmentList::setMaxZones()
     * @param int $customerId
     * @param int $maxZones
     */
    public function __construct($customerId = null, $maxZones = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setMaxZones($maxZones);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\RequestUpdatedEquipmentList
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get maxZones value
     * @return int
     */
    public function getMaxZones()
    {
        return $this->maxZones;
    }
    /**
     * Set maxZones value
     * @param int $maxZones
     * @return \CustomerManagement\StructType\RequestUpdatedEquipmentList
     */
    public function setMaxZones($maxZones = null)
    {
        // validation for constraint: int
        if (!is_null($maxZones) && !(is_int($maxZones) || ctype_digit($maxZones))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxZones, true), gettype($maxZones)), __LINE__);
        }
        $this->maxZones = $maxZones;
        return $this;
    }
}
