<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoiceAccessLevelsInput StructType
 * @subpackage Structs
 */
class GetVoiceAccessLevelsInput extends AbstractStructBase
{
    /**
     * The MobileApplicationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MobileApplicationType;
    /**
     * The LoginNameAtAuthenticationProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginNameAtAuthenticationProvider;
    /**
     * Constructor method for GetVoiceAccessLevelsInput
     * @uses GetVoiceAccessLevelsInput::setMobileApplicationType()
     * @uses GetVoiceAccessLevelsInput::setLoginNameAtAuthenticationProvider()
     * @param string $mobileApplicationType
     * @param string $loginNameAtAuthenticationProvider
     */
    public function __construct($mobileApplicationType = null, $loginNameAtAuthenticationProvider = null)
    {
        $this
            ->setMobileApplicationType($mobileApplicationType)
            ->setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider);
    }
    /**
     * Get MobileApplicationType value
     * @return string
     */
    public function getMobileApplicationType()
    {
        return $this->MobileApplicationType;
    }
    /**
     * Set MobileApplicationType value
     * @uses \CustomerManagement\EnumType\MobileApplicationTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\MobileApplicationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mobileApplicationType
     * @return \CustomerManagement\StructType\GetVoiceAccessLevelsInput
     */
    public function setMobileApplicationType($mobileApplicationType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\MobileApplicationTypeEnum::valueIsValid($mobileApplicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\MobileApplicationTypeEnum', is_array($mobileApplicationType) ? implode(', ', $mobileApplicationType) : var_export($mobileApplicationType, true), implode(', ', \CustomerManagement\EnumType\MobileApplicationTypeEnum::getValidValues())), __LINE__);
        }
        $this->MobileApplicationType = $mobileApplicationType;
        return $this;
    }
    /**
     * Get LoginNameAtAuthenticationProvider value
     * @return string|null
     */
    public function getLoginNameAtAuthenticationProvider()
    {
        return $this->LoginNameAtAuthenticationProvider;
    }
    /**
     * Set LoginNameAtAuthenticationProvider value
     * @param string $loginNameAtAuthenticationProvider
     * @return \CustomerManagement\StructType\GetVoiceAccessLevelsInput
     */
    public function setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider = null)
    {
        // validation for constraint: string
        if (!is_null($loginNameAtAuthenticationProvider) && !is_string($loginNameAtAuthenticationProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginNameAtAuthenticationProvider, true), gettype($loginNameAtAuthenticationProvider)), __LINE__);
        }
        $this->LoginNameAtAuthenticationProvider = $loginNameAtAuthenticationProvider;
        return $this;
    }
}
