<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTenantTurnoverInfoOutput StructType
 * @subpackage Structs
 */
class GetTenantTurnoverInfoOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAccountRecycleSearchResult
     */
    public $Results;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetTenantTurnoverInfoOutput
     * @uses GetTenantTurnoverInfoOutput::setSuccess()
     * @uses GetTenantTurnoverInfoOutput::setResults()
     * @uses GetTenantTurnoverInfoOutput::setErrorMessage()
     * @param bool $success
     * @param \CustomerManagement\ArrayType\ArrayOfAccountRecycleSearchResult $results
     * @param string $errorMessage
     */
    public function __construct($success = null, \CustomerManagement\ArrayType\ArrayOfAccountRecycleSearchResult $results = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setResults($results)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetTenantTurnoverInfoOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Results value
     * @return \CustomerManagement\ArrayType\ArrayOfAccountRecycleSearchResult|null
     */
    public function getResults()
    {
        return $this->Results;
    }
    /**
     * Set Results value
     * @param \CustomerManagement\ArrayType\ArrayOfAccountRecycleSearchResult $results
     * @return \CustomerManagement\StructType\GetTenantTurnoverInfoOutput
     */
    public function setResults(\CustomerManagement\ArrayType\ArrayOfAccountRecycleSearchResult $results = null)
    {
        $this->Results = $results;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetTenantTurnoverInfoOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
