<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retry ServiceType
 * @subpackage Services
 */
class Retry extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RetryRecycleAccount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Retry failed Account Recycle. Note: Not all failed recycles are able to be retried.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RetryRecycleAccount $parameters
     * @return \CustomerManagement\StructType\RetryRecycleAccountResponse|bool
     */
    public function RetryRecycleAccount(\CustomerManagement\StructType\RetryRecycleAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetryRecycleAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetryTenantTurnover
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Retry failed Tenant Turnover. Note: Not all failed turnovers are able to be retried.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RetryTenantTurnover $parameters
     * @return \CustomerManagement\StructType\RetryTenantTurnoverResponse|bool
     */
    public function RetryTenantTurnover(\CustomerManagement\StructType\RetryTenantTurnover $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetryTenantTurnover($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\RetryRecycleAccountResponse|\CustomerManagement\StructType\RetryTenantTurnoverResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
