<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllCommitmentsOutput StructType
 * @subpackage Structs
 */
class GetAllCommitmentsOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The Commitments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCommitmentInfo
     */
    public $Commitments;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetAllCommitmentsOutput
     * @uses GetAllCommitmentsOutput::setSuccess()
     * @uses GetAllCommitmentsOutput::setCommitments()
     * @uses GetAllCommitmentsOutput::setErrorMessage()
     * @param bool $success
     * @param \CustomerManagement\ArrayType\ArrayOfCommitmentInfo $commitments
     * @param string $errorMessage
     */
    public function __construct($success = null, \CustomerManagement\ArrayType\ArrayOfCommitmentInfo $commitments = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setCommitments($commitments)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetAllCommitmentsOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Commitments value
     * @return \CustomerManagement\ArrayType\ArrayOfCommitmentInfo|null
     */
    public function getCommitments()
    {
        return $this->Commitments;
    }
    /**
     * Set Commitments value
     * @param \CustomerManagement\ArrayType\ArrayOfCommitmentInfo $commitments
     * @return \CustomerManagement\StructType\GetAllCommitmentsOutput
     */
    public function setCommitments(\CustomerManagement\ArrayType\ArrayOfCommitmentInfo $commitments = null)
    {
        $this->Commitments = $commitments;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetAllCommitmentsOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
