<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEligibleSignalSourcesOutput StructType
 * @subpackage Structs
 */
class GetEligibleSignalSourcesOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The SignalSources
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfIQGen2SignalSourceEnum
     */
    public $SignalSources;
    /**
     * Constructor method for GetEligibleSignalSourcesOutput
     * @uses GetEligibleSignalSourcesOutput::setSuccess()
     * @uses GetEligibleSignalSourcesOutput::setErrorMessage()
     * @uses GetEligibleSignalSourcesOutput::setSignalSources()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfIQGen2SignalSourceEnum $signalSources
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfIQGen2SignalSourceEnum $signalSources = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setSignalSources($signalSources);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetEligibleSignalSourcesOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetEligibleSignalSourcesOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get SignalSources value
     * @return \CustomerManagement\ArrayType\ArrayOfIQGen2SignalSourceEnum|null
     */
    public function getSignalSources()
    {
        return $this->SignalSources;
    }
    /**
     * Set SignalSources value
     * @param \CustomerManagement\ArrayType\ArrayOfIQGen2SignalSourceEnum $signalSources
     * @return \CustomerManagement\StructType\GetEligibleSignalSourcesOutput
     */
    public function setSignalSources(\CustomerManagement\ArrayType\ArrayOfIQGen2SignalSourceEnum $signalSources = null)
    {
        $this->SignalSources = $signalSources;
        return $this;
    }
}
