<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for DeviceClassEnum EnumType
 * @subpackage Enumerations
 */
class DeviceClassEnum
{
    /**
     * Constant for value 'Partition'
     * @return string 'Partition'
     */
    const VALUE_PARTITION = 'Partition';
    /**
     * Constant for value 'WirelessSensor'
     * @return string 'WirelessSensor'
     */
    const VALUE_WIRELESS_SENSOR = 'WirelessSensor';
    /**
     * Constant for value 'WiredSensor'
     * @return string 'WiredSensor'
     */
    const VALUE_WIRED_SENSOR = 'WiredSensor';
    /**
     * Constant for value 'Keyfob'
     * @return string 'Keyfob'
     */
    const VALUE_KEYFOB = 'Keyfob';
    /**
     * Constant for value 'KeypadTouchscreens'
     * @return string 'KeypadTouchscreens'
     */
    const VALUE_KEYPAD_TOUCHSCREENS = 'KeypadTouchscreens';
    /**
     * Constant for value 'Siren'
     * @return string 'Siren'
     */
    const VALUE_SIREN = 'Siren';
    /**
     * Constant for value 'Repeater'
     * @return string 'Repeater'
     */
    const VALUE_REPEATER = 'Repeater';
    /**
     * Constant for value 'ExpanderModule'
     * @return string 'ExpanderModule'
     */
    const VALUE_EXPANDER_MODULE = 'ExpanderModule';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'OutputExpander'
     * @return string 'OutputExpander'
     */
    const VALUE_OUTPUT_EXPANDER = 'OutputExpander';
    /**
     * Constant for value 'PowerSupply'
     * @return string 'PowerSupply'
     */
    const VALUE_POWER_SUPPLY = 'PowerSupply';
    /**
     * Constant for value 'HighCurrentOutput'
     * @return string 'HighCurrentOutput'
     */
    const VALUE_HIGH_CURRENT_OUTPUT = 'HighCurrentOutput';
    /**
     * Constant for value 'RFTransceiver'
     * @return string 'RFTransceiver'
     */
    const VALUE_RFTRANSCEIVER = 'RFTransceiver';
    /**
     * Constant for value 'AudioModule'
     * @return string 'AudioModule'
     */
    const VALUE_AUDIO_MODULE = 'AudioModule';
    /**
     * Constant for value 'BusZoneExpander'
     * @return string 'BusZoneExpander'
     */
    const VALUE_BUS_ZONE_EXPANDER = 'BusZoneExpander';
    /**
     * Constant for value 'Invalid'
     * @return string 'Invalid'
     */
    const VALUE_INVALID = 'Invalid';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PARTITION
     * @uses self::VALUE_WIRELESS_SENSOR
     * @uses self::VALUE_WIRED_SENSOR
     * @uses self::VALUE_KEYFOB
     * @uses self::VALUE_KEYPAD_TOUCHSCREENS
     * @uses self::VALUE_SIREN
     * @uses self::VALUE_REPEATER
     * @uses self::VALUE_EXPANDER_MODULE
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_OUTPUT_EXPANDER
     * @uses self::VALUE_POWER_SUPPLY
     * @uses self::VALUE_HIGH_CURRENT_OUTPUT
     * @uses self::VALUE_RFTRANSCEIVER
     * @uses self::VALUE_AUDIO_MODULE
     * @uses self::VALUE_BUS_ZONE_EXPANDER
     * @uses self::VALUE_INVALID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PARTITION,
            self::VALUE_WIRELESS_SENSOR,
            self::VALUE_WIRED_SENSOR,
            self::VALUE_KEYFOB,
            self::VALUE_KEYPAD_TOUCHSCREENS,
            self::VALUE_SIREN,
            self::VALUE_REPEATER,
            self::VALUE_EXPANDER_MODULE,
            self::VALUE_OTHER,
            self::VALUE_OUTPUT_EXPANDER,
            self::VALUE_POWER_SUPPLY,
            self::VALUE_HIGH_CURRENT_OUTPUT,
            self::VALUE_RFTRANSCEIVER,
            self::VALUE_AUDIO_MODULE,
            self::VALUE_BUS_ZONE_EXPANDER,
            self::VALUE_INVALID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
