<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CameraWirelessSettings StructType
 * @subpackage Structs
 */
class CameraWirelessSettings extends AbstractStructBase
{
    /**
     * The EncryptionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EncryptionType;
    /**
     * The EncryptionAlgorithm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EncryptionAlgorithm;
    /**
     * The SSID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SSID;
    /**
     * The EncryptionKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EncryptionKey;
    /**
     * Constructor method for CameraWirelessSettings
     * @uses CameraWirelessSettings::setEncryptionType()
     * @uses CameraWirelessSettings::setEncryptionAlgorithm()
     * @uses CameraWirelessSettings::setSSID()
     * @uses CameraWirelessSettings::setEncryptionKey()
     * @param string $encryptionType
     * @param string $encryptionAlgorithm
     * @param string $sSID
     * @param string $encryptionKey
     */
    public function __construct($encryptionType = null, $encryptionAlgorithm = null, $sSID = null, $encryptionKey = null)
    {
        $this
            ->setEncryptionType($encryptionType)
            ->setEncryptionAlgorithm($encryptionAlgorithm)
            ->setSSID($sSID)
            ->setEncryptionKey($encryptionKey);
    }
    /**
     * Get EncryptionType value
     * @return string
     */
    public function getEncryptionType()
    {
        return $this->EncryptionType;
    }
    /**
     * Set EncryptionType value
     * @uses \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encryptionType
     * @return \CustomerManagement\StructType\CameraWirelessSettings
     */
    public function setEncryptionType($encryptionType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\WiFiEncryptionTypeEnum::valueIsValid($encryptionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\WiFiEncryptionTypeEnum', is_array($encryptionType) ? implode(', ', $encryptionType) : var_export($encryptionType, true), implode(', ', \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::getValidValues())), __LINE__);
        }
        $this->EncryptionType = $encryptionType;
        return $this;
    }
    /**
     * Get EncryptionAlgorithm value
     * @return string
     */
    public function getEncryptionAlgorithm()
    {
        return $this->EncryptionAlgorithm;
    }
    /**
     * Set EncryptionAlgorithm value
     * @uses \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encryptionAlgorithm
     * @return \CustomerManagement\StructType\CameraWirelessSettings
     */
    public function setEncryptionAlgorithm($encryptionAlgorithm = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::valueIsValid($encryptionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum', is_array($encryptionAlgorithm) ? implode(', ', $encryptionAlgorithm) : var_export($encryptionAlgorithm, true), implode(', ', \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::getValidValues())), __LINE__);
        }
        $this->EncryptionAlgorithm = $encryptionAlgorithm;
        return $this;
    }
    /**
     * Get SSID value
     * @return string|null
     */
    public function getSSID()
    {
        return $this->SSID;
    }
    /**
     * Set SSID value
     * @param string $sSID
     * @return \CustomerManagement\StructType\CameraWirelessSettings
     */
    public function setSSID($sSID = null)
    {
        // validation for constraint: string
        if (!is_null($sSID) && !is_string($sSID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSID, true), gettype($sSID)), __LINE__);
        }
        $this->SSID = $sSID;
        return $this;
    }
    /**
     * Get EncryptionKey value
     * @return string|null
     */
    public function getEncryptionKey()
    {
        return $this->EncryptionKey;
    }
    /**
     * Set EncryptionKey value
     * @param string $encryptionKey
     * @return \CustomerManagement\StructType\CameraWirelessSettings
     */
    public function setEncryptionKey($encryptionKey = null)
    {
        // validation for constraint: string
        if (!is_null($encryptionKey) && !is_string($encryptionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encryptionKey, true), gettype($encryptionKey)), __LINE__);
        }
        $this->EncryptionKey = $encryptionKey;
        return $this;
    }
}
