<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddImageSensorInput StructType
 * @subpackage Structs
 */
class AddImageSensorInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DeviceId;
    /**
     * The MAC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MAC;
    /**
     * Constructor method for AddImageSensorInput
     * @uses AddImageSensorInput::setCustomerId()
     * @uses AddImageSensorInput::setDeviceId()
     * @uses AddImageSensorInput::setMAC()
     * @param int $customerId
     * @param int $deviceId
     * @param string $mAC
     */
    public function __construct($customerId = null, $deviceId = null, $mAC = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDeviceId($deviceId)
            ->setMAC($mAC);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\AddImageSensorInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\AddImageSensorInput
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get MAC value
     * @return string|null
     */
    public function getMAC()
    {
        return $this->MAC;
    }
    /**
     * Set MAC value
     * @param string $mAC
     * @return \CustomerManagement\StructType\AddImageSensorInput
     */
    public function setMAC($mAC = null)
    {
        // validation for constraint: string
        if (!is_null($mAC) && !is_string($mAC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mAC, true), gettype($mAC)), __LINE__);
        }
        $this->MAC = $mAC;
        return $this;
    }
}
