<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLastPanelDateOutput StructType
 * @subpackage Structs
 */
class GetLastPanelDateOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The LastPanelDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastPanelDateUtc;
    /**
     * The PanelDateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelDateType;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The NullDateDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NullDateDescription;
    /**
     * Constructor method for GetLastPanelDateOutput
     * @uses GetLastPanelDateOutput::setSuccess()
     * @uses GetLastPanelDateOutput::setLastPanelDateUtc()
     * @uses GetLastPanelDateOutput::setPanelDateType()
     * @uses GetLastPanelDateOutput::setErrorMessage()
     * @uses GetLastPanelDateOutput::setNullDateDescription()
     * @param bool $success
     * @param string $lastPanelDateUtc
     * @param string $panelDateType
     * @param string $errorMessage
     * @param string $nullDateDescription
     */
    public function __construct($success = null, $lastPanelDateUtc = null, $panelDateType = null, $errorMessage = null, $nullDateDescription = null)
    {
        $this
            ->setSuccess($success)
            ->setLastPanelDateUtc($lastPanelDateUtc)
            ->setPanelDateType($panelDateType)
            ->setErrorMessage($errorMessage)
            ->setNullDateDescription($nullDateDescription);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetLastPanelDateOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get LastPanelDateUtc value
     * @return string
     */
    public function getLastPanelDateUtc()
    {
        return $this->LastPanelDateUtc;
    }
    /**
     * Set LastPanelDateUtc value
     * @param string $lastPanelDateUtc
     * @return \CustomerManagement\StructType\GetLastPanelDateOutput
     */
    public function setLastPanelDateUtc($lastPanelDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($lastPanelDateUtc) && !is_string($lastPanelDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastPanelDateUtc, true), gettype($lastPanelDateUtc)), __LINE__);
        }
        $this->LastPanelDateUtc = $lastPanelDateUtc;
        return $this;
    }
    /**
     * Get PanelDateType value
     * @return string
     */
    public function getPanelDateType()
    {
        return $this->PanelDateType;
    }
    /**
     * Set PanelDateType value
     * @uses \CustomerManagement\EnumType\PanelDateType::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelDateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelDateType
     * @return \CustomerManagement\StructType\GetLastPanelDateOutput
     */
    public function setPanelDateType($panelDateType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelDateType::valueIsValid($panelDateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PanelDateType', is_array($panelDateType) ? implode(', ', $panelDateType) : var_export($panelDateType, true), implode(', ', \CustomerManagement\EnumType\PanelDateType::getValidValues())), __LINE__);
        }
        $this->PanelDateType = $panelDateType;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetLastPanelDateOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get NullDateDescription value
     * @return string|null
     */
    public function getNullDateDescription()
    {
        return $this->NullDateDescription;
    }
    /**
     * Set NullDateDescription value
     * @param string $nullDateDescription
     * @return \CustomerManagement\StructType\GetLastPanelDateOutput
     */
    public function setNullDateDescription($nullDateDescription = null)
    {
        // validation for constraint: string
        if (!is_null($nullDateDescription) && !is_string($nullDateDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nullDateDescription, true), gettype($nullDateDescription)), __LINE__);
        }
        $this->NullDateDescription = $nullDateDescription;
        return $this;
    }
}
