<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateContractInfoInput StructType
 * @subpackage Structs
 */
class UpdateContractInfoInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The ContractEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ContractEndDate;
    /**
     * The ContractLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ContractLength;
    /**
     * Constructor method for UpdateContractInfoInput
     * @uses UpdateContractInfoInput::setCustomerId()
     * @uses UpdateContractInfoInput::setContractEndDate()
     * @uses UpdateContractInfoInput::setContractLength()
     * @param int $customerId
     * @param string $contractEndDate
     * @param int $contractLength
     */
    public function __construct($customerId = null, $contractEndDate = null, $contractLength = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setContractEndDate($contractEndDate)
            ->setContractLength($contractLength);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateContractInfoInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ContractEndDate value
     * @return string
     */
    public function getContractEndDate()
    {
        return $this->ContractEndDate;
    }
    /**
     * Set ContractEndDate value
     * @param string $contractEndDate
     * @return \CustomerManagement\StructType\UpdateContractInfoInput
     */
    public function setContractEndDate($contractEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($contractEndDate) && !is_string($contractEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractEndDate, true), gettype($contractEndDate)), __LINE__);
        }
        $this->ContractEndDate = $contractEndDate;
        return $this;
    }
    /**
     * Get ContractLength value
     * @return int
     */
    public function getContractLength()
    {
        return $this->ContractLength;
    }
    /**
     * Set ContractLength value
     * @param int $contractLength
     * @return \CustomerManagement\StructType\UpdateContractInfoInput
     */
    public function setContractLength($contractLength = null)
    {
        // validation for constraint: int
        if (!is_null($contractLength) && !(is_int($contractLength) || ctype_digit($contractLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contractLength, true), gettype($contractLength)), __LINE__);
        }
        $this->ContractLength = $contractLength;
        return $this;
    }
}
