<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllArmingSchedulesOutput StructType
 * @subpackage Structs
 */
class GetAllArmingSchedulesOutput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ExistingArmingSchedules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfExistingArmingSchedule
     */
    public $ExistingArmingSchedules;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetAllArmingSchedulesOutput
     * @uses GetAllArmingSchedulesOutput::setCustomerId()
     * @uses GetAllArmingSchedulesOutput::setSuccess()
     * @uses GetAllArmingSchedulesOutput::setExistingArmingSchedules()
     * @uses GetAllArmingSchedulesOutput::setErrorMessage()
     * @param int $customerId
     * @param bool $success
     * @param \CustomerManagement\ArrayType\ArrayOfExistingArmingSchedule $existingArmingSchedules
     * @param string $errorMessage
     */
    public function __construct($customerId = null, $success = null, \CustomerManagement\ArrayType\ArrayOfExistingArmingSchedule $existingArmingSchedules = null, $errorMessage = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSuccess($success)
            ->setExistingArmingSchedules($existingArmingSchedules)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\GetAllArmingSchedulesOutput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetAllArmingSchedulesOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ExistingArmingSchedules value
     * @return \CustomerManagement\ArrayType\ArrayOfExistingArmingSchedule|null
     */
    public function getExistingArmingSchedules()
    {
        return $this->ExistingArmingSchedules;
    }
    /**
     * Set ExistingArmingSchedules value
     * @param \CustomerManagement\ArrayType\ArrayOfExistingArmingSchedule $existingArmingSchedules
     * @return \CustomerManagement\StructType\GetAllArmingSchedulesOutput
     */
    public function setExistingArmingSchedules(\CustomerManagement\ArrayType\ArrayOfExistingArmingSchedule $existingArmingSchedules = null)
    {
        $this->ExistingArmingSchedules = $existingArmingSchedules;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetAllArmingSchedulesOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
