<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CreateNewCustomerWebsiteMessage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Create a new customer website message to display to customers.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateNewCustomerWebsiteMessage $parameters
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageResponse|bool
     */
    public function CreateNewCustomerWebsiteMessage(\CustomerManagement\StructType\CreateNewCustomerWebsiteMessage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateNewCustomerWebsiteMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateScheduledAppointmentV2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Create a scheduled service appointment for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateScheduledAppointmentV2 $parameters
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentV2Response|bool
     */
    public function CreateScheduledAppointmentV2(\CustomerManagement\StructType\CreateScheduledAppointmentV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateScheduledAppointmentV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateArmingSchedule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Create an arming schedule for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateArmingSchedule $parameters
     * @return \CustomerManagement\StructType\CreateArmingScheduleResponse|bool
     */
    public function CreateArmingSchedule(\CustomerManagement\StructType\CreateArmingSchedule $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateArmingSchedule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateCustomer $parameters
     * @return \CustomerManagement\StructType\CreateCustomerResponse|bool
     */
    public function CreateCustomer(\CustomerManagement\StructType\CreateCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCommitment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateCommitment $parameters
     * @return \CustomerManagement\StructType\CreateCommitmentResponse|bool
     */
    public function CreateCommitment(\CustomerManagement\StructType\CreateCommitment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateCommitment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCommitmentForDealer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: For Alarm.com Internal Use Only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateCommitmentForDealer $parameters
     * @return \CustomerManagement\StructType\CreateCommitmentForDealerResponse|bool
     */
    public function CreateCommitmentForDealer(\CustomerManagement\StructType\CreateCommitmentForDealer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateCommitmentForDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomerForDealer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: For Alarm.com Internal Use Only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateCustomerForDealer $parameters
     * @return \CustomerManagement\StructType\CreateCustomerForDealerResponse|bool
     */
    public function CreateCustomerForDealer(\CustomerManagement\StructType\CreateCustomerForDealer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateCustomerForDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateEnterpriseGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateEnterpriseGroup $parameters
     * @return \CustomerManagement\StructType\CreateEnterpriseGroupResponse|bool
     */
    public function CreateEnterpriseGroup(\CustomerManagement\StructType\CreateEnterpriseGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateEnterpriseGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateImageSensorAutoUploadRule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Creates a new auto-upload rule for image sensor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateImageSensorAutoUploadRule $parameters
     * @return \CustomerManagement\StructType\CreateImageSensorAutoUploadRuleResponse|bool
     */
    public function CreateImageSensorAutoUploadRule(\CustomerManagement\StructType\CreateImageSensorAutoUploadRule $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateImageSensorAutoUploadRule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\CreateArmingScheduleResponse|\CustomerManagement\StructType\CreateCommitmentForDealerResponse|\CustomerManagement\StructType\CreateCommitmentResponse|\CustomerManagement\StructType\CreateCustomerForDealerResponse|\CustomerManagement\StructType\CreateCustomerResponse|\CustomerManagement\StructType\CreateEnterpriseGroupResponse|\CustomerManagement\StructType\CreateImageSensorAutoUploadRuleResponse|\CustomerManagement\StructType\CreateNewCustomerWebsiteMessageResponse|\CustomerManagement\StructType\CreateScheduledAppointmentV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
