<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCameraSettings StructType
 * @subpackage Structs
 */
class UpdateCameraSettings extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The mac
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mac;
    /**
     * The settings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\CameraSettings
     */
    public $settings;
    /**
     * Constructor method for UpdateCameraSettings
     * @uses UpdateCameraSettings::setCustomerId()
     * @uses UpdateCameraSettings::setMac()
     * @uses UpdateCameraSettings::setSettings()
     * @param int $customerId
     * @param string $mac
     * @param \CustomerManagement\StructType\CameraSettings $settings
     */
    public function __construct($customerId = null, $mac = null, \CustomerManagement\StructType\CameraSettings $settings = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setMac($mac)
            ->setSettings($settings);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCameraSettings
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \CustomerManagement\StructType\UpdateCameraSettings
     */
    public function setMac($mac = null)
    {
        // validation for constraint: string
        if (!is_null($mac) && !is_string($mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mac)), __LINE__);
        }
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get settings value
     * @return \CustomerManagement\StructType\CameraSettings|null
     */
    public function getSettings()
    {
        return $this->settings;
    }
    /**
     * Set settings value
     * @param \CustomerManagement\StructType\CameraSettings $settings
     * @return \CustomerManagement\StructType\UpdateCameraSettings
     */
    public function setSettings(\CustomerManagement\StructType\CameraSettings $settings = null)
    {
        $this->settings = $settings;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateCameraSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
