<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CreateScheduledAppointment
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Create a scheduled service appointment for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateScheduledAppointment $parameters
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentResponse|bool
     */
    public function CreateScheduledAppointment(\CustomerManagement\StructType\CreateScheduledAppointment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateScheduledAppointment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSolarConnection
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Create a new solar connection for the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateSolarConnection $parameters
     * @return \CustomerManagement\StructType\CreateSolarConnectionResponse|bool
     */
    public function CreateSolarConnection(\CustomerManagement\StructType\CreateSolarConnection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateSolarConnection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomer
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateCustomer $parameters
     * @return \CustomerManagement\StructType\CreateCustomerResponse|bool
     */
    public function CreateCustomer(\CustomerManagement\StructType\CreateCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCommitment
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateCommitment $parameters
     * @return \CustomerManagement\StructType\CreateCommitmentResponse|bool
     */
    public function CreateCommitment(\CustomerManagement\StructType\CreateCommitment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCommitment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCommitmentForDealer
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: For Alarm.com Internal Use Only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateCommitmentForDealer $parameters
     * @return \CustomerManagement\StructType\CreateCommitmentForDealerResponse|bool
     */
    public function CreateCommitmentForDealer(\CustomerManagement\StructType\CreateCommitmentForDealer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCommitmentForDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomerForDealer
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: For Alarm.com Internal Use Only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateCustomerForDealer $parameters
     * @return \CustomerManagement\StructType\CreateCustomerForDealerResponse|bool
     */
    public function CreateCustomerForDealer(\CustomerManagement\StructType\CreateCustomerForDealer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomerForDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateImageSensorAutoUploadRule
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Creates a new auto-upload rule for image sensor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateImageSensorAutoUploadRule $parameters
     * @return \CustomerManagement\StructType\CreateImageSensorAutoUploadRuleResponse|bool
     */
    public function CreateImageSensorAutoUploadRule(\CustomerManagement\StructType\CreateImageSensorAutoUploadRule $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateImageSensorAutoUploadRule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateNewCustomerWebsiteMessage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Create a new customer website message to display to customers.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\CreateNewCustomerWebsiteMessage $parameters
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageResponse|bool
     */
    public function CreateNewCustomerWebsiteMessage(\CustomerManagement\StructType\CreateNewCustomerWebsiteMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateNewCustomerWebsiteMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\CreateCommitmentForDealerResponse|\CustomerManagement\StructType\CreateCommitmentResponse|\CustomerManagement\StructType\CreateCustomerForDealerResponse|\CustomerManagement\StructType\CreateCustomerResponse|\CustomerManagement\StructType\CreateImageSensorAutoUploadRuleResponse|\CustomerManagement\StructType\CreateNewCustomerWebsiteMessageResponse|\CustomerManagement\StructType\CreateScheduledAppointmentResponse|\CustomerManagement\StructType\CreateSolarConnectionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
