<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduledServiceDateInfo StructType
 * @subpackage Structs
 */
class ScheduledServiceDateInfo extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The ServiceDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceDateUtc;
    /**
     * The CustomerLocalizedServiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomerLocalizedServiceDate;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The TechnicianId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TechnicianId;
    /**
     * The ConfirmationSent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ConfirmationSent;
    /**
     * The SendReminder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendReminder;
    /**
     * The UpsellOfferIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $UpsellOfferIds;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for ScheduledServiceDateInfo
     * @uses ScheduledServiceDateInfo::setId()
     * @uses ScheduledServiceDateInfo::setStatus()
     * @uses ScheduledServiceDateInfo::setServiceDateUtc()
     * @uses ScheduledServiceDateInfo::setCustomerLocalizedServiceDate()
     * @uses ScheduledServiceDateInfo::setCustomerId()
     * @uses ScheduledServiceDateInfo::setTechnicianId()
     * @uses ScheduledServiceDateInfo::setConfirmationSent()
     * @uses ScheduledServiceDateInfo::setSendReminder()
     * @uses ScheduledServiceDateInfo::setUpsellOfferIds()
     * @uses ScheduledServiceDateInfo::setNotes()
     * @param int $id
     * @param string $status
     * @param string $serviceDateUtc
     * @param string $customerLocalizedServiceDate
     * @param int $customerId
     * @param int $technicianId
     * @param bool $confirmationSent
     * @param bool $sendReminder
     * @param \CustomerManagement\ArrayType\ArrayOfInt $upsellOfferIds
     * @param string $notes
     */
    public function __construct($id = null, $status = null, $serviceDateUtc = null, $customerLocalizedServiceDate = null, $customerId = null, $technicianId = null, $confirmationSent = null, $sendReminder = null, \CustomerManagement\ArrayType\ArrayOfInt $upsellOfferIds = null, $notes = null)
    {
        $this
            ->setId($id)
            ->setStatus($status)
            ->setServiceDateUtc($serviceDateUtc)
            ->setCustomerLocalizedServiceDate($customerLocalizedServiceDate)
            ->setCustomerId($customerId)
            ->setTechnicianId($technicianId)
            ->setConfirmationSent($confirmationSent)
            ->setSendReminder($sendReminder)
            ->setUpsellOfferIds($upsellOfferIds)
            ->setNotes($notes);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \CustomerManagement\EnumType\ScheduledServiceDateStatus::valueIsValid()
     * @uses \CustomerManagement\EnumType\ScheduledServiceDateStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ScheduledServiceDateStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\ScheduledServiceDateStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \CustomerManagement\EnumType\ScheduledServiceDateStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ServiceDateUtc value
     * @return string
     */
    public function getServiceDateUtc()
    {
        return $this->ServiceDateUtc;
    }
    /**
     * Set ServiceDateUtc value
     * @param string $serviceDateUtc
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfo
     */
    public function setServiceDateUtc($serviceDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDateUtc) && !is_string($serviceDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDateUtc, true), gettype($serviceDateUtc)), __LINE__);
        }
        $this->ServiceDateUtc = $serviceDateUtc;
        return $this;
    }
    /**
     * Get CustomerLocalizedServiceDate value
     * @return string
     */
    public function getCustomerLocalizedServiceDate()
    {
        return $this->CustomerLocalizedServiceDate;
    }
    /**
     * Set CustomerLocalizedServiceDate value
     * @param string $customerLocalizedServiceDate
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfo
     */
    public function setCustomerLocalizedServiceDate($customerLocalizedServiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($customerLocalizedServiceDate) && !is_string($customerLocalizedServiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerLocalizedServiceDate, true), gettype($customerLocalizedServiceDate)), __LINE__);
        }
        $this->CustomerLocalizedServiceDate = $customerLocalizedServiceDate;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfo
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get TechnicianId value
     * @return int
     */
    public function getTechnicianId()
    {
        return $this->TechnicianId;
    }
    /**
     * Set TechnicianId value
     * @param int $technicianId
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfo
     */
    public function setTechnicianId($technicianId = null)
    {
        // validation for constraint: int
        if (!is_null($technicianId) && !(is_int($technicianId) || ctype_digit($technicianId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($technicianId, true), gettype($technicianId)), __LINE__);
        }
        $this->TechnicianId = $technicianId;
        return $this;
    }
    /**
     * Get ConfirmationSent value
     * @return bool
     */
    public function getConfirmationSent()
    {
        return $this->ConfirmationSent;
    }
    /**
     * Set ConfirmationSent value
     * @param bool $confirmationSent
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfo
     */
    public function setConfirmationSent($confirmationSent = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmationSent) && !is_bool($confirmationSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confirmationSent, true), gettype($confirmationSent)), __LINE__);
        }
        $this->ConfirmationSent = $confirmationSent;
        return $this;
    }
    /**
     * Get SendReminder value
     * @return bool
     */
    public function getSendReminder()
    {
        return $this->SendReminder;
    }
    /**
     * Set SendReminder value
     * @param bool $sendReminder
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfo
     */
    public function setSendReminder($sendReminder = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendReminder) && !is_bool($sendReminder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendReminder, true), gettype($sendReminder)), __LINE__);
        }
        $this->SendReminder = $sendReminder;
        return $this;
    }
    /**
     * Get UpsellOfferIds value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getUpsellOfferIds()
    {
        return $this->UpsellOfferIds;
    }
    /**
     * Set UpsellOfferIds value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $upsellOfferIds
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfo
     */
    public function setUpsellOfferIds(\CustomerManagement\ArrayType\ArrayOfInt $upsellOfferIds = null)
    {
        $this->UpsellOfferIds = $upsellOfferIds;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfo
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
}
