<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PowerSourceTypeEnum EnumType
 * @subpackage Enumerations
 */
class PowerSourceTypeEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'AcPower'
     * @return string 'AcPower'
     */
    const VALUE_AC_POWER = 'AcPower';
    /**
     * Constant for value 'ExternalBattery'
     * @return string 'ExternalBattery'
     */
    const VALUE_EXTERNAL_BATTERY = 'ExternalBattery';
    /**
     * Constant for value 'InternalBattery'
     * @return string 'InternalBattery'
     */
    const VALUE_INTERNAL_BATTERY = 'InternalBattery';
    /**
     * Constant for value 'SolarPower'
     * @return string 'SolarPower'
     */
    const VALUE_SOLAR_POWER = 'SolarPower';
    /**
     * Constant for value 'UsbPower'
     * @return string 'UsbPower'
     */
    const VALUE_USB_POWER = 'UsbPower';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return allowed values
     * @uses self::VALUE_AC_POWER
     * @uses self::VALUE_EXTERNAL_BATTERY
     * @uses self::VALUE_INTERNAL_BATTERY
     * @uses self::VALUE_SOLAR_POWER
     * @uses self::VALUE_USB_POWER
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AC_POWER,
            self::VALUE_EXTERNAL_BATTERY,
            self::VALUE_INTERNAL_BATTERY,
            self::VALUE_SOLAR_POWER,
            self::VALUE_USB_POWER,
            self::VALUE_UNKNOWN,
        );
    }
}
