<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateScheduledAppointmentInput StructType
 * @subpackage Structs
 */
class CreateScheduledAppointmentInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateUtc;
    /**
     * The TechnicianId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TechnicianId;
    /**
     * The Confirmation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Confirmation;
    /**
     * The Reminder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Reminder;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The JobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobId;
    /**
     * Constructor method for CreateScheduledAppointmentInput
     * @uses CreateScheduledAppointmentInput::setCustomerId()
     * @uses CreateScheduledAppointmentInput::setDateUtc()
     * @uses CreateScheduledAppointmentInput::setTechnicianId()
     * @uses CreateScheduledAppointmentInput::setConfirmation()
     * @uses CreateScheduledAppointmentInput::setReminder()
     * @uses CreateScheduledAppointmentInput::setNotes()
     * @uses CreateScheduledAppointmentInput::setJobId()
     * @param int $customerId
     * @param string $dateUtc
     * @param int $technicianId
     * @param bool $confirmation
     * @param bool $reminder
     * @param string $notes
     * @param string $jobId
     */
    public function __construct($customerId = null, $dateUtc = null, $technicianId = null, $confirmation = null, $reminder = null, $notes = null, $jobId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDateUtc($dateUtc)
            ->setTechnicianId($technicianId)
            ->setConfirmation($confirmation)
            ->setReminder($reminder)
            ->setNotes($notes)
            ->setJobId($jobId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DateUtc value
     * @return string
     */
    public function getDateUtc()
    {
        return $this->DateUtc;
    }
    /**
     * Set DateUtc value
     * @param string $dateUtc
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInput
     */
    public function setDateUtc($dateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dateUtc) && !is_string($dateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateUtc, true), gettype($dateUtc)), __LINE__);
        }
        $this->DateUtc = $dateUtc;
        return $this;
    }
    /**
     * Get TechnicianId value
     * @return int
     */
    public function getTechnicianId()
    {
        return $this->TechnicianId;
    }
    /**
     * Set TechnicianId value
     * @param int $technicianId
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInput
     */
    public function setTechnicianId($technicianId = null)
    {
        // validation for constraint: int
        if (!is_null($technicianId) && !(is_int($technicianId) || ctype_digit($technicianId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($technicianId, true), gettype($technicianId)), __LINE__);
        }
        $this->TechnicianId = $technicianId;
        return $this;
    }
    /**
     * Get Confirmation value
     * @return bool
     */
    public function getConfirmation()
    {
        return $this->Confirmation;
    }
    /**
     * Set Confirmation value
     * @param bool $confirmation
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInput
     */
    public function setConfirmation($confirmation = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmation) && !is_bool($confirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confirmation, true), gettype($confirmation)), __LINE__);
        }
        $this->Confirmation = $confirmation;
        return $this;
    }
    /**
     * Get Reminder value
     * @return bool
     */
    public function getReminder()
    {
        return $this->Reminder;
    }
    /**
     * Set Reminder value
     * @param bool $reminder
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInput
     */
    public function setReminder($reminder = null)
    {
        // validation for constraint: boolean
        if (!is_null($reminder) && !is_bool($reminder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reminder, true), gettype($reminder)), __LINE__);
        }
        $this->Reminder = $reminder;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInput
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get JobId value
     * @return string|null
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param string $jobId
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInput
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: string
        if (!is_null($jobId) && !is_string($jobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
}
