<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfZWaveRoutingTableInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfZWaveRoutingTableInfo extends AbstractStructArrayBase
{
    /**
     * The ZWaveRoutingTableInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\ZWaveRoutingTableInfo[]
     */
    public $ZWaveRoutingTableInfo;
    /**
     * Constructor method for ArrayOfZWaveRoutingTableInfo
     * @uses ArrayOfZWaveRoutingTableInfo::setZWaveRoutingTableInfo()
     * @param \CustomerManagement\StructType\ZWaveRoutingTableInfo[] $zWaveRoutingTableInfo
     */
    public function __construct(array $zWaveRoutingTableInfo = array())
    {
        $this
            ->setZWaveRoutingTableInfo($zWaveRoutingTableInfo);
    }
    /**
     * Get ZWaveRoutingTableInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\ZWaveRoutingTableInfo[]|null
     */
    public function getZWaveRoutingTableInfo()
    {
        return isset($this->ZWaveRoutingTableInfo) ? $this->ZWaveRoutingTableInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setZWaveRoutingTableInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZWaveRoutingTableInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZWaveRoutingTableInfoForArrayConstraintsFromSetZWaveRoutingTableInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfZWaveRoutingTableInfoZWaveRoutingTableInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfZWaveRoutingTableInfoZWaveRoutingTableInfoItem instanceof \CustomerManagement\StructType\ZWaveRoutingTableInfo) {
                $invalidValues[] = is_object($arrayOfZWaveRoutingTableInfoZWaveRoutingTableInfoItem) ? get_class($arrayOfZWaveRoutingTableInfoZWaveRoutingTableInfoItem) : sprintf('%s(%s)', gettype($arrayOfZWaveRoutingTableInfoZWaveRoutingTableInfoItem), var_export($arrayOfZWaveRoutingTableInfoZWaveRoutingTableInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZWaveRoutingTableInfo property can only contain items of type \CustomerManagement\StructType\ZWaveRoutingTableInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZWaveRoutingTableInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\ZWaveRoutingTableInfo[] $zWaveRoutingTableInfo
     * @return \CustomerManagement\ArrayType\ArrayOfZWaveRoutingTableInfo
     */
    public function setZWaveRoutingTableInfo(array $zWaveRoutingTableInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($zWaveRoutingTableInfoArrayErrorMessage = self::validateZWaveRoutingTableInfoForArrayConstraintsFromSetZWaveRoutingTableInfo($zWaveRoutingTableInfo))) {
            throw new \InvalidArgumentException($zWaveRoutingTableInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($zWaveRoutingTableInfo) || (is_array($zWaveRoutingTableInfo) && empty($zWaveRoutingTableInfo))) {
            unset($this->ZWaveRoutingTableInfo);
        } else {
            $this->ZWaveRoutingTableInfo = $zWaveRoutingTableInfo;
        }
        return $this;
    }
    /**
     * Add item to ZWaveRoutingTableInfo value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\ZWaveRoutingTableInfo $item
     * @return \CustomerManagement\ArrayType\ArrayOfZWaveRoutingTableInfo
     */
    public function addToZWaveRoutingTableInfo(\CustomerManagement\StructType\ZWaveRoutingTableInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\ZWaveRoutingTableInfo) {
            throw new \InvalidArgumentException(sprintf('The ZWaveRoutingTableInfo property can only contain items of type \CustomerManagement\StructType\ZWaveRoutingTableInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZWaveRoutingTableInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\ZWaveRoutingTableInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\ZWaveRoutingTableInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\ZWaveRoutingTableInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\ZWaveRoutingTableInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\ZWaveRoutingTableInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ZWaveRoutingTableInfo
     */
    public function getAttributeName()
    {
        return 'ZWaveRoutingTableInfo';
    }
}
