<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerAddressInput StructType
 * @subpackage Structs
 */
class UpdateCustomerAddressInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The UseGivenAddressForBoth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseGivenAddressForBoth;
    /**
     * The InstallAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\Address
     */
    public $InstallAddress;
    /**
     * The CustomerAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\Address
     */
    public $CustomerAddress;
    /**
     * Constructor method for UpdateCustomerAddressInput
     * @uses UpdateCustomerAddressInput::setCustomerId()
     * @uses UpdateCustomerAddressInput::setUseGivenAddressForBoth()
     * @uses UpdateCustomerAddressInput::setInstallAddress()
     * @uses UpdateCustomerAddressInput::setCustomerAddress()
     * @param int $customerId
     * @param bool $useGivenAddressForBoth
     * @param \CustomerManagement\StructType\Address $installAddress
     * @param \CustomerManagement\StructType\Address $customerAddress
     */
    public function __construct($customerId = null, $useGivenAddressForBoth = null, \CustomerManagement\StructType\Address $installAddress = null, \CustomerManagement\StructType\Address $customerAddress = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setUseGivenAddressForBoth($useGivenAddressForBoth)
            ->setInstallAddress($installAddress)
            ->setCustomerAddress($customerAddress);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomerAddressInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get UseGivenAddressForBoth value
     * @return bool
     */
    public function getUseGivenAddressForBoth()
    {
        return $this->UseGivenAddressForBoth;
    }
    /**
     * Set UseGivenAddressForBoth value
     * @param bool $useGivenAddressForBoth
     * @return \CustomerManagement\StructType\UpdateCustomerAddressInput
     */
    public function setUseGivenAddressForBoth($useGivenAddressForBoth = null)
    {
        // validation for constraint: boolean
        if (!is_null($useGivenAddressForBoth) && !is_bool($useGivenAddressForBoth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useGivenAddressForBoth, true), gettype($useGivenAddressForBoth)), __LINE__);
        }
        $this->UseGivenAddressForBoth = $useGivenAddressForBoth;
        return $this;
    }
    /**
     * Get InstallAddress value
     * @return \CustomerManagement\StructType\Address|null
     */
    public function getInstallAddress()
    {
        return $this->InstallAddress;
    }
    /**
     * Set InstallAddress value
     * @param \CustomerManagement\StructType\Address $installAddress
     * @return \CustomerManagement\StructType\UpdateCustomerAddressInput
     */
    public function setInstallAddress(\CustomerManagement\StructType\Address $installAddress = null)
    {
        $this->InstallAddress = $installAddress;
        return $this;
    }
    /**
     * Get CustomerAddress value
     * @return \CustomerManagement\StructType\Address|null
     */
    public function getCustomerAddress()
    {
        return $this->CustomerAddress;
    }
    /**
     * Set CustomerAddress value
     * @param \CustomerManagement\StructType\Address $customerAddress
     * @return \CustomerManagement\StructType\UpdateCustomerAddressInput
     */
    public function setCustomerAddress(\CustomerManagement\StructType\Address $customerAddress = null)
    {
        $this->CustomerAddress = $customerAddress;
        return $this;
    }
}
