<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckPanelSettingsBackupOutput StructType
 * @subpackage Structs
 */
class CheckPanelSettingsBackupOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The BackedUpSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfDeviceSettingBackupInfo
     */
    public $BackedUpSettings;
    /**
     * Constructor method for CheckPanelSettingsBackupOutput
     * @uses CheckPanelSettingsBackupOutput::setSuccess()
     * @uses CheckPanelSettingsBackupOutput::setErrorMessage()
     * @uses CheckPanelSettingsBackupOutput::setBackedUpSettings()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceSettingBackupInfo $backedUpSettings
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfDeviceSettingBackupInfo $backedUpSettings = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setBackedUpSettings($backedUpSettings);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\CheckPanelSettingsBackupOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\CheckPanelSettingsBackupOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get BackedUpSettings value
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceSettingBackupInfo|null
     */
    public function getBackedUpSettings()
    {
        return $this->BackedUpSettings;
    }
    /**
     * Set BackedUpSettings value
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceSettingBackupInfo $backedUpSettings
     * @return \CustomerManagement\StructType\CheckPanelSettingsBackupOutput
     */
    public function setBackedUpSettings(\CustomerManagement\ArrayType\ArrayOfDeviceSettingBackupInfo $backedUpSettings = null)
    {
        $this->BackedUpSettings = $backedUpSettings;
        return $this;
    }
}
