<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ChangeServicePlan
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the package and addons for a customer. You need to pass the full set of addons that you want, not just the changes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\ChangeServicePlan $parameters
     * @return \CustomerManagement\StructType\ChangeServicePlanResponse|bool
     */
    public function ChangeServicePlan(\CustomerManagement\StructType\ChangeServicePlan $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeServicePlan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeServicePlanValidationOnly
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Does a dry run of updating the package and addons for a customer. You need to pass the full set of addons that you want, not just the changes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\ChangeServicePlanValidationOnly $parameters
     * @return \CustomerManagement\StructType\ChangeServicePlanValidationOnlyResponse|bool
     */
    public function ChangeServicePlanValidationOnly(\CustomerManagement\StructType\ChangeServicePlanValidationOnly $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeServicePlanValidationOnly($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeServicePlanTemplate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the customer's service plan to be the specified custom package template.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\ChangeServicePlanTemplate $parameters
     * @return \CustomerManagement\StructType\ChangeServicePlanTemplateResponse|bool
     */
    public function ChangeServicePlanTemplate(\CustomerManagement\StructType\ChangeServicePlanTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeServicePlanTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\ChangeServicePlanResponse|\CustomerManagement\StructType\ChangeServicePlanTemplateResponse|\CustomerManagement\StructType\ChangeServicePlanValidationOnlyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
