<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for WebsiteMessageClearingOptionEnum EnumType
 * @subpackage Enumerations
 */
class WebsiteMessageClearingOptionEnum
{
    /**
     * Constant for value 'PerLogin'
     * @return string 'PerLogin'
     */
    const VALUE_PER_LOGIN = 'PerLogin';
    /**
     * Constant for value 'PerCustomer'
     * @return string 'PerCustomer'
     */
    const VALUE_PER_CUSTOMER = 'PerCustomer';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PER_LOGIN
     * @uses self::VALUE_PER_CUSTOMER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PER_LOGIN,
            self::VALUE_PER_CUSTOMER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
