<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNeighbor ArrayType
 * @subpackage Arrays
 */
class ArrayOfNeighbor extends AbstractStructArrayBase
{
    /**
     * The Neighbor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\Neighbor[]
     */
    public $Neighbor;
    /**
     * Constructor method for ArrayOfNeighbor
     * @uses ArrayOfNeighbor::setNeighbor()
     * @param \CustomerManagement\StructType\Neighbor[] $neighbor
     */
    public function __construct(array $neighbor = array())
    {
        $this
            ->setNeighbor($neighbor);
    }
    /**
     * Get Neighbor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\Neighbor[]|null
     */
    public function getNeighbor()
    {
        return isset($this->Neighbor) ? $this->Neighbor : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNeighbor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNeighbor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNeighborForArrayConstraintsFromSetNeighbor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNeighborNeighborItem) {
            // validation for constraint: itemType
            if (!$arrayOfNeighborNeighborItem instanceof \CustomerManagement\StructType\Neighbor) {
                $invalidValues[] = is_object($arrayOfNeighborNeighborItem) ? get_class($arrayOfNeighborNeighborItem) : sprintf('%s(%s)', gettype($arrayOfNeighborNeighborItem), var_export($arrayOfNeighborNeighborItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Neighbor property can only contain items of type \CustomerManagement\StructType\Neighbor, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Neighbor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\Neighbor[] $neighbor
     * @return \CustomerManagement\ArrayType\ArrayOfNeighbor
     */
    public function setNeighbor(array $neighbor = array())
    {
        // validation for constraint: array
        if ('' !== ($neighborArrayErrorMessage = self::validateNeighborForArrayConstraintsFromSetNeighbor($neighbor))) {
            throw new \InvalidArgumentException($neighborArrayErrorMessage, __LINE__);
        }
        if (is_null($neighbor) || (is_array($neighbor) && empty($neighbor))) {
            unset($this->Neighbor);
        } else {
            $this->Neighbor = $neighbor;
        }
        return $this;
    }
    /**
     * Add item to Neighbor value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\Neighbor $item
     * @return \CustomerManagement\ArrayType\ArrayOfNeighbor
     */
    public function addToNeighbor(\CustomerManagement\StructType\Neighbor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\Neighbor) {
            throw new \InvalidArgumentException(sprintf('The Neighbor property can only contain items of type \CustomerManagement\StructType\Neighbor, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Neighbor[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\Neighbor|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\Neighbor|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\Neighbor|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\Neighbor|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\Neighbor|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Neighbor
     */
    public function getAttributeName()
    {
        return 'Neighbor';
    }
}
