<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicePlanAuditOutput StructType
 * @subpackage Structs
 */
class ServicePlanAuditOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ServicePlanHistory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCustomerPackage
     */
    public $ServicePlanHistory;
    /**
     * The AddOnHistory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAddOnHistoryItem
     */
    public $AddOnHistory;
    /**
     * Constructor method for ServicePlanAuditOutput
     * @uses ServicePlanAuditOutput::setSuccess()
     * @uses ServicePlanAuditOutput::setErrorMessage()
     * @uses ServicePlanAuditOutput::setServicePlanHistory()
     * @uses ServicePlanAuditOutput::setAddOnHistory()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerPackage $servicePlanHistory
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnHistoryItem $addOnHistory
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfCustomerPackage $servicePlanHistory = null, \CustomerManagement\ArrayType\ArrayOfAddOnHistoryItem $addOnHistory = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setServicePlanHistory($servicePlanHistory)
            ->setAddOnHistory($addOnHistory);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\ServicePlanAuditOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\ServicePlanAuditOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get ServicePlanHistory value
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerPackage|null
     */
    public function getServicePlanHistory()
    {
        return $this->ServicePlanHistory;
    }
    /**
     * Set ServicePlanHistory value
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerPackage $servicePlanHistory
     * @return \CustomerManagement\StructType\ServicePlanAuditOutput
     */
    public function setServicePlanHistory(\CustomerManagement\ArrayType\ArrayOfCustomerPackage $servicePlanHistory = null)
    {
        $this->ServicePlanHistory = $servicePlanHistory;
        return $this;
    }
    /**
     * Get AddOnHistory value
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnHistoryItem|null
     */
    public function getAddOnHistory()
    {
        return $this->AddOnHistory;
    }
    /**
     * Set AddOnHistory value
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnHistoryItem $addOnHistory
     * @return \CustomerManagement\StructType\ServicePlanAuditOutput
     */
    public function setAddOnHistory(\CustomerManagement\ArrayType\ArrayOfAddOnHistoryItem $addOnHistory = null)
    {
        $this->AddOnHistory = $addOnHistory;
        return $this;
    }
}
