<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCommunicationSettingOutput StructType
 * @subpackage Structs
 */
class GetCommunicationSettingOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The DualPathMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DualPathMode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetCommunicationSettingOutput
     * @uses GetCommunicationSettingOutput::setSuccess()
     * @uses GetCommunicationSettingOutput::setDualPathMode()
     * @uses GetCommunicationSettingOutput::setErrorMessage()
     * @param bool $success
     * @param string $dualPathMode
     * @param string $errorMessage
     */
    public function __construct($success = null, $dualPathMode = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setDualPathMode($dualPathMode)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetCommunicationSettingOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get DualPathMode value
     * @return string
     */
    public function getDualPathMode()
    {
        return $this->DualPathMode;
    }
    /**
     * Set DualPathMode value
     * @uses \CustomerManagement\EnumType\DualPathModeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DualPathModeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dualPathMode
     * @return \CustomerManagement\StructType\GetCommunicationSettingOutput
     */
    public function setDualPathMode($dualPathMode = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DualPathModeEnum::valueIsValid($dualPathMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DualPathModeEnum', is_array($dualPathMode) ? implode(', ', $dualPathMode) : var_export($dualPathMode, true), implode(', ', \CustomerManagement\EnumType\DualPathModeEnum::getValidValues())), __LINE__);
        }
        $this->DualPathMode = $dualPathMode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetCommunicationSettingOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
