<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEmailPreferencesInput StructType
 * @subpackage Structs
 */
class UpdateEmailPreferencesInput extends AbstractStructBase
{
    /**
     * The LoginId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoginId;
    /**
     * The ENewsSubscribed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ENewsSubscribed;
    /**
     * The ProductAnnouncementsSubscribed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ProductAnnouncementsSubscribed;
    /**
     * The PromotionsSubscribed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PromotionsSubscribed;
    /**
     * Constructor method for UpdateEmailPreferencesInput
     * @uses UpdateEmailPreferencesInput::setLoginId()
     * @uses UpdateEmailPreferencesInput::setENewsSubscribed()
     * @uses UpdateEmailPreferencesInput::setProductAnnouncementsSubscribed()
     * @uses UpdateEmailPreferencesInput::setPromotionsSubscribed()
     * @param int $loginId
     * @param bool $eNewsSubscribed
     * @param bool $productAnnouncementsSubscribed
     * @param bool $promotionsSubscribed
     */
    public function __construct($loginId = null, $eNewsSubscribed = null, $productAnnouncementsSubscribed = null, $promotionsSubscribed = null)
    {
        $this
            ->setLoginId($loginId)
            ->setENewsSubscribed($eNewsSubscribed)
            ->setProductAnnouncementsSubscribed($productAnnouncementsSubscribed)
            ->setPromotionsSubscribed($promotionsSubscribed);
    }
    /**
     * Get LoginId value
     * @return int
     */
    public function getLoginId()
    {
        return $this->LoginId;
    }
    /**
     * Set LoginId value
     * @param int $loginId
     * @return \CustomerManagement\StructType\UpdateEmailPreferencesInput
     */
    public function setLoginId($loginId = null)
    {
        // validation for constraint: int
        if (!is_null($loginId) && !(is_int($loginId) || ctype_digit($loginId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loginId, true), gettype($loginId)), __LINE__);
        }
        $this->LoginId = $loginId;
        return $this;
    }
    /**
     * Get ENewsSubscribed value
     * @return bool
     */
    public function getENewsSubscribed()
    {
        return $this->ENewsSubscribed;
    }
    /**
     * Set ENewsSubscribed value
     * @param bool $eNewsSubscribed
     * @return \CustomerManagement\StructType\UpdateEmailPreferencesInput
     */
    public function setENewsSubscribed($eNewsSubscribed = null)
    {
        // validation for constraint: boolean
        if (!is_null($eNewsSubscribed) && !is_bool($eNewsSubscribed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eNewsSubscribed, true), gettype($eNewsSubscribed)), __LINE__);
        }
        $this->ENewsSubscribed = $eNewsSubscribed;
        return $this;
    }
    /**
     * Get ProductAnnouncementsSubscribed value
     * @return bool
     */
    public function getProductAnnouncementsSubscribed()
    {
        return $this->ProductAnnouncementsSubscribed;
    }
    /**
     * Set ProductAnnouncementsSubscribed value
     * @param bool $productAnnouncementsSubscribed
     * @return \CustomerManagement\StructType\UpdateEmailPreferencesInput
     */
    public function setProductAnnouncementsSubscribed($productAnnouncementsSubscribed = null)
    {
        // validation for constraint: boolean
        if (!is_null($productAnnouncementsSubscribed) && !is_bool($productAnnouncementsSubscribed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($productAnnouncementsSubscribed, true), gettype($productAnnouncementsSubscribed)), __LINE__);
        }
        $this->ProductAnnouncementsSubscribed = $productAnnouncementsSubscribed;
        return $this;
    }
    /**
     * Get PromotionsSubscribed value
     * @return bool
     */
    public function getPromotionsSubscribed()
    {
        return $this->PromotionsSubscribed;
    }
    /**
     * Set PromotionsSubscribed value
     * @param bool $promotionsSubscribed
     * @return \CustomerManagement\StructType\UpdateEmailPreferencesInput
     */
    public function setPromotionsSubscribed($promotionsSubscribed = null)
    {
        // validation for constraint: boolean
        if (!is_null($promotionsSubscribed) && !is_bool($promotionsSubscribed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($promotionsSubscribed, true), gettype($promotionsSubscribed)), __LINE__);
        }
        $this->PromotionsSubscribed = $promotionsSubscribed;
        return $this;
    }
}
