<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRolesInput StructType
 * @subpackage Structs
 */
class UpdateRolesInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The LoginIdToUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoginIdToUpdate;
    /**
     * The Roles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $Roles;
    /**
     * Constructor method for UpdateRolesInput
     * @uses UpdateRolesInput::setCustomerId()
     * @uses UpdateRolesInput::setLoginIdToUpdate()
     * @uses UpdateRolesInput::setRoles()
     * @param int $customerId
     * @param int $loginIdToUpdate
     * @param \CustomerManagement\ArrayType\ArrayOfInt $roles
     */
    public function __construct($customerId = null, $loginIdToUpdate = null, \CustomerManagement\ArrayType\ArrayOfInt $roles = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setLoginIdToUpdate($loginIdToUpdate)
            ->setRoles($roles);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateRolesInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get LoginIdToUpdate value
     * @return int
     */
    public function getLoginIdToUpdate()
    {
        return $this->LoginIdToUpdate;
    }
    /**
     * Set LoginIdToUpdate value
     * @param int $loginIdToUpdate
     * @return \CustomerManagement\StructType\UpdateRolesInput
     */
    public function setLoginIdToUpdate($loginIdToUpdate = null)
    {
        // validation for constraint: int
        if (!is_null($loginIdToUpdate) && !(is_int($loginIdToUpdate) || ctype_digit($loginIdToUpdate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loginIdToUpdate, true), gettype($loginIdToUpdate)), __LINE__);
        }
        $this->LoginIdToUpdate = $loginIdToUpdate;
        return $this;
    }
    /**
     * Get Roles value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getRoles()
    {
        return $this->Roles;
    }
    /**
     * Set Roles value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $roles
     * @return \CustomerManagement\StructType\UpdateRolesInput
     */
    public function setRoles(\CustomerManagement\ArrayType\ArrayOfInt $roles = null)
    {
        $this->Roles = $roles;
        return $this;
    }
}
