<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSummary StructType
 * @subpackage Structs
 */
class CustomerSummary extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The CustomerType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomerType;
    /**
     * The SystemGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SystemGroupId;
    /**
     * The UnitDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitDescription;
    /**
     * The CustomerRoles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $CustomerRoles;
    /**
     * The AlternateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlternateId;
    /**
     * The InstallAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\Address
     */
    public $InstallAddress;
    /**
     * Constructor method for CustomerSummary
     * @uses CustomerSummary::setCustomerId()
     * @uses CustomerSummary::setCustomerType()
     * @uses CustomerSummary::setSystemGroupId()
     * @uses CustomerSummary::setUnitDescription()
     * @uses CustomerSummary::setCustomerRoles()
     * @uses CustomerSummary::setAlternateId()
     * @uses CustomerSummary::setInstallAddress()
     * @param int $customerId
     * @param string $customerType
     * @param int $systemGroupId
     * @param string $unitDescription
     * @param \CustomerManagement\ArrayType\ArrayOfInt $customerRoles
     * @param string $alternateId
     * @param \CustomerManagement\StructType\Address $installAddress
     */
    public function __construct($customerId = null, $customerType = null, $systemGroupId = null, $unitDescription = null, \CustomerManagement\ArrayType\ArrayOfInt $customerRoles = null, $alternateId = null, \CustomerManagement\StructType\Address $installAddress = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setCustomerType($customerType)
            ->setSystemGroupId($systemGroupId)
            ->setUnitDescription($unitDescription)
            ->setCustomerRoles($customerRoles)
            ->setAlternateId($alternateId)
            ->setInstallAddress($installAddress);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return string
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @uses \CustomerManagement\EnumType\CustomerTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerType
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerTypeEnum::valueIsValid($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CustomerTypeEnum', is_array($customerType) ? implode(', ', $customerType) : var_export($customerType, true), implode(', ', \CustomerManagement\EnumType\CustomerTypeEnum::getValidValues())), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get SystemGroupId value
     * @return int
     */
    public function getSystemGroupId()
    {
        return $this->SystemGroupId;
    }
    /**
     * Set SystemGroupId value
     * @param int $systemGroupId
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setSystemGroupId($systemGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($systemGroupId) && !(is_int($systemGroupId) || ctype_digit($systemGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemGroupId, true), gettype($systemGroupId)), __LINE__);
        }
        $this->SystemGroupId = $systemGroupId;
        return $this;
    }
    /**
     * Get UnitDescription value
     * @return string|null
     */
    public function getUnitDescription()
    {
        return $this->UnitDescription;
    }
    /**
     * Set UnitDescription value
     * @param string $unitDescription
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setUnitDescription($unitDescription = null)
    {
        // validation for constraint: string
        if (!is_null($unitDescription) && !is_string($unitDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitDescription, true), gettype($unitDescription)), __LINE__);
        }
        $this->UnitDescription = $unitDescription;
        return $this;
    }
    /**
     * Get CustomerRoles value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getCustomerRoles()
    {
        return $this->CustomerRoles;
    }
    /**
     * Set CustomerRoles value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $customerRoles
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setCustomerRoles(\CustomerManagement\ArrayType\ArrayOfInt $customerRoles = null)
    {
        $this->CustomerRoles = $customerRoles;
        return $this;
    }
    /**
     * Get AlternateId value
     * @return string|null
     */
    public function getAlternateId()
    {
        return $this->AlternateId;
    }
    /**
     * Set AlternateId value
     * @param string $alternateId
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setAlternateId($alternateId = null)
    {
        // validation for constraint: string
        if (!is_null($alternateId) && !is_string($alternateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateId, true), gettype($alternateId)), __LINE__);
        }
        $this->AlternateId = $alternateId;
        return $this;
    }
    /**
     * Get InstallAddress value
     * @return \CustomerManagement\StructType\Address|null
     */
    public function getInstallAddress()
    {
        return $this->InstallAddress;
    }
    /**
     * Set InstallAddress value
     * @param \CustomerManagement\StructType\Address $installAddress
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setInstallAddress(\CustomerManagement\StructType\Address $installAddress = null)
    {
        $this->InstallAddress = $installAddress;
        return $this;
    }
}
