<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestRemoteRoutineInspectionInput StructType
 * @subpackage Structs
 */
class RequestRemoteRoutineInspectionInput extends AbstractStructBase
{
    /**
     * The NumberOfEvents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfEvents;
    /**
     * The FrequentlyUsedDeviceTimeframe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FrequentlyUsedDeviceTimeframe;
    /**
     * The ClockFaultAllowance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClockFaultAllowance;
    /**
     * The ShouldCorrectClock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShouldCorrectClock;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The InternalEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternalEmail;
    /**
     * Constructor method for RequestRemoteRoutineInspectionInput
     * @uses RequestRemoteRoutineInspectionInput::setNumberOfEvents()
     * @uses RequestRemoteRoutineInspectionInput::setFrequentlyUsedDeviceTimeframe()
     * @uses RequestRemoteRoutineInspectionInput::setClockFaultAllowance()
     * @uses RequestRemoteRoutineInspectionInput::setShouldCorrectClock()
     * @uses RequestRemoteRoutineInspectionInput::setCustomerId()
     * @uses RequestRemoteRoutineInspectionInput::setInternalEmail()
     * @param int $numberOfEvents
     * @param int $frequentlyUsedDeviceTimeframe
     * @param int $clockFaultAllowance
     * @param bool $shouldCorrectClock
     * @param int $customerId
     * @param string $internalEmail
     */
    public function __construct($numberOfEvents = null, $frequentlyUsedDeviceTimeframe = null, $clockFaultAllowance = null, $shouldCorrectClock = null, $customerId = null, $internalEmail = null)
    {
        $this
            ->setNumberOfEvents($numberOfEvents)
            ->setFrequentlyUsedDeviceTimeframe($frequentlyUsedDeviceTimeframe)
            ->setClockFaultAllowance($clockFaultAllowance)
            ->setShouldCorrectClock($shouldCorrectClock)
            ->setCustomerId($customerId)
            ->setInternalEmail($internalEmail);
    }
    /**
     * Get NumberOfEvents value
     * @return int
     */
    public function getNumberOfEvents()
    {
        return $this->NumberOfEvents;
    }
    /**
     * Set NumberOfEvents value
     * @param int $numberOfEvents
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput
     */
    public function setNumberOfEvents($numberOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfEvents) && !(is_int($numberOfEvents) || ctype_digit($numberOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfEvents, true), gettype($numberOfEvents)), __LINE__);
        }
        $this->NumberOfEvents = $numberOfEvents;
        return $this;
    }
    /**
     * Get FrequentlyUsedDeviceTimeframe value
     * @return int
     */
    public function getFrequentlyUsedDeviceTimeframe()
    {
        return $this->FrequentlyUsedDeviceTimeframe;
    }
    /**
     * Set FrequentlyUsedDeviceTimeframe value
     * @param int $frequentlyUsedDeviceTimeframe
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput
     */
    public function setFrequentlyUsedDeviceTimeframe($frequentlyUsedDeviceTimeframe = null)
    {
        // validation for constraint: int
        if (!is_null($frequentlyUsedDeviceTimeframe) && !(is_int($frequentlyUsedDeviceTimeframe) || ctype_digit($frequentlyUsedDeviceTimeframe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($frequentlyUsedDeviceTimeframe, true), gettype($frequentlyUsedDeviceTimeframe)), __LINE__);
        }
        $this->FrequentlyUsedDeviceTimeframe = $frequentlyUsedDeviceTimeframe;
        return $this;
    }
    /**
     * Get ClockFaultAllowance value
     * @return int
     */
    public function getClockFaultAllowance()
    {
        return $this->ClockFaultAllowance;
    }
    /**
     * Set ClockFaultAllowance value
     * @param int $clockFaultAllowance
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput
     */
    public function setClockFaultAllowance($clockFaultAllowance = null)
    {
        // validation for constraint: int
        if (!is_null($clockFaultAllowance) && !(is_int($clockFaultAllowance) || ctype_digit($clockFaultAllowance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clockFaultAllowance, true), gettype($clockFaultAllowance)), __LINE__);
        }
        $this->ClockFaultAllowance = $clockFaultAllowance;
        return $this;
    }
    /**
     * Get ShouldCorrectClock value
     * @return bool
     */
    public function getShouldCorrectClock()
    {
        return $this->ShouldCorrectClock;
    }
    /**
     * Set ShouldCorrectClock value
     * @param bool $shouldCorrectClock
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput
     */
    public function setShouldCorrectClock($shouldCorrectClock = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldCorrectClock) && !is_bool($shouldCorrectClock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldCorrectClock, true), gettype($shouldCorrectClock)), __LINE__);
        }
        $this->ShouldCorrectClock = $shouldCorrectClock;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get InternalEmail value
     * @return string|null
     */
    public function getInternalEmail()
    {
        return $this->InternalEmail;
    }
    /**
     * Set InternalEmail value
     * @param string $internalEmail
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionInput
     */
    public function setInternalEmail($internalEmail = null)
    {
        // validation for constraint: string
        if (!is_null($internalEmail) && !is_string($internalEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalEmail, true), gettype($internalEmail)), __LINE__);
        }
        $this->InternalEmail = $internalEmail;
        return $this;
    }
}
